/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.event;

import com.google.common.collect.HashMultimap;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.google.common.collect.Multimap;
import com.stal111.valhelsia_structures.common.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.core.ValhelsiaStructures;
import com.stal111.valhelsia_structures.core.config.ModConfig;
import com.stal111.valhelsia_structures.core.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.core.init.ModStructures;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.core.Registry;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.resources.ResourceKey;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.biome.Biome;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.FlatLevelSource;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.event.world.WorldEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.valhelsia.valhelsia_core.common.world.IValhelsiaStructure;

@Mod.EventBusSubscriber
public class WorldLoadListener {
    @SubscribeEvent
    public static void onWorldLoad(WorldEvent.Load event) {
        LevelAccessor levelAccessor = event.getWorld();
        if (!(levelAccessor instanceof ServerLevel)) {
            return;
        }
        ServerLevel level = (ServerLevel)levelAccessor;
        ChunkGenerator generator = level.m_7726_().m_8481_();
        if (generator instanceof FlatLevelSource && level.m_46472_().equals((Object)Level.f_46428_)) {
            return;
        }
        StructureSettings structureSettings = generator.m_62205_();
        HashMap structureToMultiMap = new HashMap();
        block0: for (Map.Entry biomeEntry : level.m_5962_().m_175512_(Registry.f_122885_).m_6579_()) {
            Biome.BiomeCategory category = ((Biome)biomeEntry.getValue()).m_47567_();
            ResourceLocation name = ((Biome)biomeEntry.getValue()).getRegistryName();
            if (name == null) continue;
            for (String biome : (List)ModConfig.COMMON.blacklistedBiomes.get()) {
                if (!biome.equals(name.toString()) && !WorldLoadListener.checkWildcard(biome, name.toString())) continue;
                continue block0;
            }
            for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
                AbstractValhelsiaStructure structure = (AbstractValhelsiaStructure)iStructure.getStructure();
                StructureConfigEntry configEntry = structure.getStructureConfigEntry();
                if (!((Boolean)configEntry.generate.get()).booleanValue() || !WorldLoadListener.checkBiome((List)configEntry.configuredBiomeCategories.get(), (List)configEntry.configuredBlacklistedBiomes.get(), name, category)) continue;
                WorldLoadListener.associateBiomeToConfiguredStructure(structureToMultiMap, structure.getStructureFeature(), (ResourceKey<Biome>)((ResourceKey)biomeEntry.getKey()));
            }
        }
        ImmutableMap.Builder tempStructureToMultiMap = ImmutableMap.builder();
        structureSettings.f_189361_.entrySet().stream().filter(entry -> !structureToMultiMap.containsKey(entry.getKey())).forEach(arg_0 -> ((ImmutableMap.Builder)tempStructureToMultiMap).put(arg_0));
        structureToMultiMap.forEach((key, value) -> tempStructureToMultiMap.put(key, (Object)ImmutableMultimap.copyOf((Multimap)value)));
        structureSettings.f_189361_ = tempStructureToMultiMap.build();
        HashMap<AbstractValhelsiaStructure, StructureFeatureConfiguration> tempMap = new HashMap<AbstractValhelsiaStructure, StructureFeatureConfiguration>(structureSettings.m_64590_());
        ResourceLocation currDimension = level.m_46472_().m_135782_();
        for (String dimension : (List)ModConfig.COMMON.blacklistedDimensions.get()) {
            if (!dimension.equals(currDimension.toString())) {
                if (!WorldLoadListener.checkWildcard(dimension, currDimension.toString())) continue;
            }
            ModStructures.MOD_STRUCTURES.stream().map(IValhelsiaStructure::getStructure).toList().forEach(tempMap.keySet()::remove);
            generator.m_62205_().f_64582_ = tempMap;
            return;
        }
        for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
            AbstractValhelsiaStructure structure = (AbstractValhelsiaStructure)iStructure.getStructure();
            StructureConfigEntry configEntry = structure.getStructureConfigEntry();
            if (WorldLoadListener.checkDimension((List)configEntry.configuredBlacklistedDimensions.get(), currDimension)) {
                tempMap.putIfAbsent(structure, (StructureFeatureConfiguration)StructureSettings.f_64580_.get((Object)structure));
                continue;
            }
            tempMap.keySet().remove((Object)structure);
        }
        structureSettings.f_64582_ = tempMap;
    }

    private static boolean checkWildcard(String blacklistedDimension, String dimension) {
        if (blacklistedDimension.startsWith("*") && blacklistedDimension.endsWith("*")) {
            return dimension.contains(blacklistedDimension.substring(1, blacklistedDimension.length() - 1));
        }
        if (blacklistedDimension.startsWith("*")) {
            return dimension.endsWith(blacklistedDimension.substring(1));
        }
        if (blacklistedDimension.endsWith("*")) {
            return dimension.startsWith(blacklistedDimension.substring(0, blacklistedDimension.length() - 1));
        }
        return false;
    }

    private static boolean checkDimension(List<? extends String> blacklistedDimensions, ResourceLocation name) {
        boolean flag = true;
        if (!blacklistedDimensions.isEmpty()) {
            boolean bl = flag = !blacklistedDimensions.contains(name.toString());
            if (flag) {
                for (String string : blacklistedDimensions) {
                    if (!WorldLoadListener.checkWildcard(string, name.toString())) continue;
                    flag = false;
                    break;
                }
            }
        }
        return flag;
    }

    private static boolean checkBiome(List<? extends String> allowedBiomeCategories, List<? extends String> blacklistedBiomes, ResourceLocation name, Biome.BiomeCategory category) {
        boolean flag = allowedBiomeCategories.contains(category.m_47645_());
        if (!blacklistedBiomes.isEmpty() && flag) {
            boolean bl = flag = !blacklistedBiomes.contains(name.toString());
            if (flag) {
                for (String string : blacklistedBiomes) {
                    if (!WorldLoadListener.checkWildcard(string, name.toString())) continue;
                    flag = false;
                    break;
                }
            }
        }
        return flag;
    }

    private static void associateBiomeToConfiguredStructure(Map<StructureFeature<?>, HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>>> structureToMultiMap, ConfiguredStructureFeature<?, ?> configuredStructureFeature, ResourceKey<Biome> biomeRegistryKey) {
        structureToMultiMap.putIfAbsent(configuredStructureFeature.f_65403_, HashMultimap.create());
        System.out.println(configuredStructureFeature.f_65403_.getRegistryName());
        HashMultimap<ConfiguredStructureFeature<?, ?>, ResourceKey<Biome>> configuredStructureToBiomeMultiMap = structureToMultiMap.get(configuredStructureFeature.f_65403_);
        if (configuredStructureToBiomeMultiMap.containsValue(biomeRegistryKey)) {
            ValhelsiaStructures.LOGGER.error("    Detected 2 ConfiguredStructureFeatures that share the same base StructureFeature trying to be added to same biome. One will be prevented from spawning.\n    This issue happens with vanilla too and is why a Snowy Village and Plains Village cannot spawn in the same biome because they both use the Village base structure.\n    The two conflicting ConfiguredStructures are: {}, {}\n    The biome that is attempting to be shared: {}\n", (Object)BuiltinRegistries.f_123862_.m_7447_(configuredStructureFeature), (Object)BuiltinRegistries.f_123862_.m_7447_((Object)((ConfiguredStructureFeature)configuredStructureToBiomeMultiMap.entries().stream().filter(e -> e.getValue() == biomeRegistryKey).findFirst().get().getKey())), biomeRegistryKey);
        } else {
            configuredStructureToBiomeMultiMap.put(configuredStructureFeature, biomeRegistryKey);
        }
    }
}

