/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.common.world.structures;

import com.mojang.datafixers.util.Pair;
import com.mojang.serialization.Codec;
import com.stal111.valhelsia_structures.core.config.ModConfig;
import com.stal111.valhelsia_structures.core.config.StructureConfigEntry;
import com.stal111.valhelsia_structures.core.init.ModStructures;
import com.stal111.valhelsia_structures.utils.StructureUtils;
import java.util.ArrayList;
import java.util.Optional;
import java.util.function.Function;
import java.util.function.Predicate;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.ChunkPos;
import net.minecraft.world.level.NoiseColumn;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.chunk.ChunkGenerator;
import net.minecraft.world.level.levelgen.GenerationStep;
import net.minecraft.world.level.levelgen.Heightmap;
import net.minecraft.world.level.levelgen.LegacyRandomSource;
import net.minecraft.world.level.levelgen.RandomSource;
import net.minecraft.world.level.levelgen.WorldgenRandom;
import net.minecraft.world.level.levelgen.feature.ConfiguredStructureFeature;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraft.world.level.levelgen.feature.structures.JigsawPlacement;
import net.minecraft.world.level.levelgen.structure.BoundingBox;
import net.minecraft.world.level.levelgen.structure.PoolElementStructurePiece;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGenerator;
import net.minecraft.world.level.levelgen.structure.pieces.PieceGeneratorSupplier;
import net.valhelsia.valhelsia_core.common.world.IValhelsiaStructure;
import net.valhelsia.valhelsia_core.common.world.ValhelsiaJigsawStructure;

public abstract class AbstractValhelsiaStructure
extends ValhelsiaJigsawStructure<JigsawConfiguration> {
    private final StructureConfigEntry structureConfigEntry;

    public AbstractValhelsiaStructure(Codec<JigsawConfiguration> codec, String name, Predicate<PieceGeneratorSupplier.Context<JigsawConfiguration>> locationCheckPredicate, Function<PieceGeneratorSupplier.Context<JigsawConfiguration>, Optional<PieceGenerator<JigsawConfiguration>>> pieceCreationPredicate, StructureConfigEntry structureConfigEntry) {
        super(codec, name, locationCheckPredicate, pieceCreationPredicate);
        this.structureConfigEntry = structureConfigEntry;
    }

    protected boolean isFeatureChunk(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        BlockPos pos = context.f_197355_().m_45615_();
        ChunkGenerator generator = context.f_197352_();
        WorldgenRandom random = new WorldgenRandom((RandomSource)new LegacyRandomSource(0L));
        if (this.checkSurface() && !this.isSurfaceFlat(context)) {
            return false;
        }
        if (!this.canGenerateOnWater()) {
            int landHeight = generator.m_156179_(pos.m_123341_(), pos.m_123343_(), Heightmap.Types.WORLD_SURFACE_WG, context.f_197357_());
            NoiseColumn columnOfBlocks = generator.m_141914_(pos.m_123341_(), pos.m_123343_(), context.f_197357_());
            BlockState topBlock = columnOfBlocks.m_183556_(landHeight);
            if (!topBlock.m_60819_().m_76178_()) {
                return false;
            }
        }
        if (this.m_67095_() == GenerationStep.Decoration.SURFACE_STRUCTURES) {
            ArrayList structures = new ArrayList();
            for (IValhelsiaStructure iStructure : ModStructures.MOD_STRUCTURES) {
                StructureFeature structure = iStructure.getStructure();
                if (structure.m_67095_() != this.m_67095_()) continue;
                structures.add(structure);
            }
            structures.add(StructureFeature.f_67028_);
            return StructureUtils.checkForOtherStructures(this, generator, context.f_197354_(), context.f_197355_(), structures);
        }
        return true;
    }

    @Nonnull
    public String m_67098_() {
        return new ResourceLocation("valhelsia_structures", this.getName()).toString();
    }

    private boolean isSurfaceFlat(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        ChunkPos pos = context.f_197355_();
        int[] cornerHeights = context.m_197375_(pos.m_151390_(), ((Integer)this.getSize().getFirst()).intValue(), pos.m_151393_(), ((Integer)this.getSize().getSecond()).intValue());
        int minHeight = Math.min(Math.min(cornerHeights[0], cornerHeights[1]), Math.min(cornerHeights[2], cornerHeights[3]));
        int maxHeight = Math.max(Math.max(cornerHeights[0], cornerHeights[1]), Math.max(cornerHeights[2], cornerHeights[3]));
        return Math.abs(maxHeight - minHeight) <= (Integer)ModConfig.COMMON.flatnessDelta.get();
    }

    @Nonnull
    public GenerationStep.Decoration m_67095_() {
        return GenerationStep.Decoration.SURFACE_STRUCTURES;
    }

    public boolean transformsSurroundingLand() {
        return true;
    }

    public abstract Pair<Integer, Integer> getSize();

    public StructureConfigEntry getStructureConfigEntry() {
        return this.structureConfigEntry;
    }

    public int getSpacing() {
        return Math.max((Integer)this.getStructureConfigEntry().configuredSpacing.get(), this.getSeparation() + 1);
    }

    public int getSeparation() {
        return (Integer)this.getStructureConfigEntry().configuredSeparation.get();
    }

    public abstract int getSeedModifier();

    public StructureFeatureConfiguration getFeatureConfiguration() {
        return new StructureFeatureConfiguration(this.getSpacing(), this.getSeparation(), this.getSeedModifier());
    }

    public double getSpawnChance() {
        return (Double)this.getStructureConfigEntry().configuredSpawnChance.get();
    }

    public abstract ConfiguredStructureFeature<JigsawConfiguration, ? extends StructureFeature<JigsawConfiguration>> getStructureFeature();

    public boolean checkSurface() {
        return true;
    }

    public boolean canGenerateOnWater() {
        return false;
    }

    public boolean hasMargin() {
        return true;
    }

    public int getMargin() {
        return 12;
    }

    @Nonnull
    public BoundingBox m_183606_(@Nonnull BoundingBox boundingBox) {
        return super.m_183606_(boundingBox).m_191961_(this.hasMargin() ? this.getMargin() : 0);
    }

    public int getGenerationHeight() {
        return -1;
    }

    public Optional<PieceGenerator<JigsawConfiguration>> generatePieces(PieceGeneratorSupplier.Context<JigsawConfiguration> context) {
        boolean flag = this.getGenerationHeight() == -1;
        BlockPos pos = context.f_197355_().m_151394_(flag ? 0 : this.getGenerationHeight());
        return JigsawPlacement.m_197210_(context, PoolElementStructurePiece::new, (BlockPos)pos, (boolean)true, (boolean)flag);
    }
}

