/*
 * Decompiled with CFR 0.152.
 */
package com.stal111.valhelsia_structures.core.init;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.mojang.serialization.Codec;
import com.stal111.valhelsia_structures.common.world.structures.AbstractValhelsiaStructure;
import com.stal111.valhelsia_structures.common.world.structures.BigTreeStructure;
import com.stal111.valhelsia_structures.common.world.structures.CastleRuinStructure;
import com.stal111.valhelsia_structures.common.world.structures.CastleStructure;
import com.stal111.valhelsia_structures.common.world.structures.DesertHouseStructure;
import com.stal111.valhelsia_structures.common.world.structures.ForgeStructure;
import com.stal111.valhelsia_structures.common.world.structures.PlayerHouseStructure;
import com.stal111.valhelsia_structures.common.world.structures.SpawnerDungeonStructure;
import com.stal111.valhelsia_structures.common.world.structures.TowerRuinStructure;
import com.stal111.valhelsia_structures.common.world.structures.WitchHutStructure;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.minecraft.data.BuiltinRegistries;
import net.minecraft.world.level.levelgen.NoiseGeneratorSettings;
import net.minecraft.world.level.levelgen.StructureSettings;
import net.minecraft.world.level.levelgen.feature.StructureFeature;
import net.minecraft.world.level.levelgen.feature.configurations.JigsawConfiguration;
import net.minecraft.world.level.levelgen.feature.configurations.StructureFeatureConfiguration;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import net.valhelsia.valhelsia_core.common.world.IValhelsiaStructure;

public class ModStructures {
    public static final List<IValhelsiaStructure> MOD_STRUCTURES = new ArrayList<IValhelsiaStructure>();
    public static final DeferredRegister<StructureFeature<?>> STRUCTURES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.STRUCTURE_FEATURES, (String)"valhelsia_structures");
    public static final RegistryObject<CastleStructure> CASTLE = ModStructures.register(CastleStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<CastleRuinStructure> CASTLE_RUIN = ModStructures.register(CastleRuinStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<DesertHouseStructure> DESERT_HOUSE = ModStructures.register(DesertHouseStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<ForgeStructure> FORGE = ModStructures.register(ForgeStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<PlayerHouseStructure> PLAYER_HOUSE = ModStructures.register(PlayerHouseStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<SpawnerDungeonStructure> SPAWNER_DUNGEON = ModStructures.register(SpawnerDungeonStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<TowerRuinStructure> TOWER_RUIN = ModStructures.register(TowerRuinStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<WitchHutStructure> WITCH_HUT = ModStructures.register(WitchHutStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));
    public static final RegistryObject<BigTreeStructure> BIG_TREE = ModStructures.register(BigTreeStructure.create((Codec<JigsawConfiguration>)JigsawConfiguration.f_67756_));

    private static <T extends AbstractValhelsiaStructure> RegistryObject<T> register(T structure) {
        MOD_STRUCTURES.add((IValhelsiaStructure)structure);
        return STRUCTURES.register(structure.getName(), () -> structure);
    }

    public static void setupStructures() {
        for (IValhelsiaStructure structure : MOD_STRUCTURES) {
            StructureFeature structureFeature = structure.getStructure();
            StructureFeatureConfiguration featureConfiguration = structure.getFeatureConfiguration();
            StructureFeature.f_67012_.put((Object)Objects.requireNonNull(structureFeature.getRegistryName()).toString(), (Object)structureFeature);
            if (structure.transformsSurroundingLand()) {
                StructureFeature.f_67031_ = ImmutableList.builder().addAll((Iterable)StructureFeature.f_67031_).add((Object)structureFeature).build();
            }
            StructureSettings.f_64580_ = ImmutableMap.builder().putAll((Map)StructureSettings.f_64580_).put((Object)structureFeature, (Object)featureConfiguration).build();
            BuiltinRegistries.f_123866_.m_6579_().forEach(settings -> {
                Map structureMap = ((NoiseGeneratorSettings)settings.getValue()).m_64457_().m_64590_();
                if (structureMap instanceof ImmutableMap) {
                    HashMap<StructureFeature, StructureFeatureConfiguration> tempMap = new HashMap<StructureFeature, StructureFeatureConfiguration>(structureMap);
                    tempMap.put(structureFeature, featureConfiguration);
                    ((NoiseGeneratorSettings)settings.getValue()).m_64457_().f_64582_ = tempMap;
                } else {
                    structureMap.put(structureFeature, featureConfiguration);
                }
            });
        }
    }
}

