/*
 * Decompiled with CFR 0.152.
 */
package net.valhelsia.valhelsia_core.client.cosmetics;

import javax.annotation.Nullable;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraftforge.common.ForgeConfigSpec;
import net.valhelsia.valhelsia_core.client.cosmetics.Cosmetic;

public enum CosmeticsCategory {
    HAT("hat"),
    BACK("back"),
    HAND("hand"),
    FACE("face"),
    SPECIAL("special");

    private final String name;
    private final TranslatableComponent component;
    public ForgeConfigSpec.ConfigValue<String> activeCosmetic;

    private CosmeticsCategory(String name) {
        this.name = name;
        this.component = new TranslatableComponent("cosmetic.valhelsia_core.category." + name);
    }

    public String getName() {
        return this.name;
    }

    public TranslatableComponent getComponent() {
        return this.component;
    }

    @Nullable
    public Cosmetic getActiveCosmetic() {
        return ((String)this.activeCosmetic.get()).equals("") ? null : new Cosmetic((String)this.activeCosmetic.get(), this);
    }

    public void setActiveCosmetic(String name) {
        this.activeCosmetic.set((Object)name);
    }

    public static CosmeticsCategory getForCosmetic(String cosmeticName) {
        if (cosmeticName.contains("hat")) {
            return HAT;
        }
        if (cosmeticName.contains("cape")) {
            return BACK;
        }
        if (cosmeticName.contains("beanie")) {
            return HAT;
        }
        if (cosmeticName.contains("scarf")) {
            return FACE;
        }
        return switch (cosmeticName) {
            case "green_witchs_wand", "purple_witchs_wand" -> HAND;
            case "witchs_broom" -> SPECIAL;
            case "cauldron_backpack" -> BACK;
            default -> null;
        };
    }
}

