/*
 * Decompiled with CFR 0.152.
 */
package com.macaronsteam.amethysttoolsmod.entity;

import com.macaronsteam.amethysttoolsmod.config.AmethystToolsModConfig;
import com.macaronsteam.amethysttoolsmod.init.EntitiesInit;
import com.macaronsteam.amethysttoolsmod.init.ItemsInit;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.core.Registry;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.EntityDataSerializers;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.projectile.AbstractArrow;
import net.minecraft.world.entity.projectile.Arrow;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.alchemy.Potion;
import net.minecraft.world.item.alchemy.PotionUtils;
import net.minecraft.world.item.alchemy.Potions;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;

public class AmethystArrowEntity
extends AbstractArrow {
    private static final EntityDataAccessor<Integer> ID_EFFECT_COLOR = SynchedEntityData.m_135353_(Arrow.class, (EntityDataSerializer)EntityDataSerializers.f_135028_);
    private final Set<MobEffectInstance> effects = new HashSet<MobEffectInstance>();
    private boolean fixedColor;
    private Potion potion = Potions.f_43598_;

    public static int getCustomColor(ItemStack itemstack) {
        CompoundTag tag = itemstack.m_41783_();
        return tag != null && tag.m_128425_("CustomPotionColor", 99) ? tag.m_128451_("CustomPotionColor") : -1;
    }

    public AmethystArrowEntity(EntityType<? extends AmethystArrowEntity> entitytype, Level level) {
        super(entitytype, level);
    }

    public AmethystArrowEntity(Level level, double x, double y, double z) {
        super((EntityType)EntitiesInit.ENTITY_AMETHYST_ARROW.get(), x, y, z, level);
    }

    public AmethystArrowEntity(Level level, ItemStack itemstack, LivingEntity livingentity) {
        this(level, livingentity);
        this.setEffectsFromItem(itemstack);
    }

    public AmethystArrowEntity(Level level, LivingEntity livingentity) {
        super((EntityType)EntitiesInit.ENTITY_AMETHYST_ARROW.get(), livingentity, level);
        this.m_36781_(this.m_36789_() + (Double)AmethystToolsModConfig.arrowExtraDamage.get());
    }

    public void m_7380_(CompoundTag compoundtag) {
        super.m_7380_(compoundtag);
        if (this.potion != Potions.f_43598_) {
            compoundtag.m_128359_("Potion", Registry.f_122828_.m_7981_((Object)this.potion).toString());
        }
        if (this.fixedColor) {
            compoundtag.m_128405_("Color", this.getColor());
        }
        if (!this.effects.isEmpty()) {
            ListTag listtag = new ListTag();
            for (MobEffectInstance mobeffectinstance : this.effects) {
                listtag.add((Object)mobeffectinstance.m_19555_(new CompoundTag()));
            }
            compoundtag.m_128365_("CustomPotionEffects", (Tag)listtag);
        }
    }

    public void addEffect(MobEffectInstance mobeffectinstance) {
        this.effects.add(mobeffectinstance);
        this.m_20088_().m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
    }

    protected void m_8097_() {
        super.m_8097_();
        this.f_19804_.m_135372_(ID_EFFECT_COLOR, (Object)-1);
    }

    protected void m_7761_(LivingEntity livingentity) {
        super.m_7761_(livingentity);
        Entity entity = this.m_150173_();
        for (MobEffectInstance mobeffectinstance : this.potion.m_43488_()) {
            livingentity.m_147207_(new MobEffectInstance(mobeffectinstance.m_19544_(), Math.max(mobeffectinstance.m_19557_() / 8, 1), mobeffectinstance.m_19564_(), mobeffectinstance.m_19571_(), mobeffectinstance.m_19572_()), entity);
        }
        if (!this.effects.isEmpty()) {
            for (MobEffectInstance mobeffectinstance1 : this.effects) {
                livingentity.m_147207_(mobeffectinstance1, entity);
            }
        }
    }

    public int getColor() {
        return (Integer)this.f_19804_.m_135370_(ID_EFFECT_COLOR);
    }

    protected ItemStack m_7941_() {
        if (this.effects.isEmpty() && this.potion == Potions.f_43598_) {
            return new ItemStack((ItemLike)ItemsInit.ITEM_AMETHYST_ARROW.get());
        }
        ItemStack itemstack = new ItemStack((ItemLike)ItemsInit.ITEM_AMETHYST_TIPPED_ARROW.get());
        PotionUtils.m_43549_((ItemStack)itemstack, (Potion)this.potion);
        PotionUtils.m_43552_((ItemStack)itemstack, this.effects);
        if (this.fixedColor) {
            itemstack.m_41784_().m_128405_("CustomPotionColor", this.getColor());
        }
        return itemstack;
    }

    public void m_7822_(byte d) {
        if (d == 0) {
            int i = this.getColor();
            if (i != -1) {
                double d0 = (double)(i >> 16 & 0xFF) / 255.0;
                double d1 = (double)(i >> 8 & 0xFF) / 255.0;
                double d2 = (double)(i >> 0 & 0xFF) / 255.0;
                for (int j = 0; j < 20; ++j) {
                    this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
                }
            }
        } else {
            super.m_7822_(d);
        }
    }

    private void makeParticle(int d) {
        int i = this.getColor();
        if (i != -1 && d > 0) {
            double d0 = (double)(i >> 16 & 0xFF) / 255.0;
            double d1 = (double)(i >> 8 & 0xFF) / 255.0;
            double d2 = (double)(i >> 0 & 0xFF) / 255.0;
            for (int j = 0; j < d; ++j) {
                this.f_19853_.m_7106_((ParticleOptions)ParticleTypes.f_123811_, this.m_20208_(0.5), this.m_20187_(), this.m_20262_(0.5), d0, d1, d2);
            }
        }
    }

    public void m_7378_(CompoundTag compoundtag) {
        super.m_7378_(compoundtag);
        if (compoundtag.m_128425_("Potion", 8)) {
            this.potion = PotionUtils.m_43577_((CompoundTag)compoundtag);
        }
        for (MobEffectInstance mobeffectinstance : PotionUtils.m_43573_((CompoundTag)compoundtag)) {
            this.addEffect(mobeffectinstance);
        }
        if (compoundtag.m_128425_("Color", 99)) {
            this.setFixedColor(compoundtag.m_128451_("Color"));
        } else {
            this.updateColor();
        }
    }

    public void setEffectsFromItem(ItemStack itemstack) {
        if (itemstack.m_150930_((Item)ItemsInit.ITEM_AMETHYST_TIPPED_ARROW.get())) {
            int i;
            this.potion = PotionUtils.m_43579_((ItemStack)itemstack);
            List collection = PotionUtils.m_43571_((ItemStack)itemstack);
            if (!collection.isEmpty()) {
                for (MobEffectInstance mobeffectinstance : collection) {
                    this.effects.add(new MobEffectInstance(mobeffectinstance));
                }
            }
            if ((i = AmethystArrowEntity.getCustomColor(itemstack)) == -1) {
                this.updateColor();
            } else {
                this.setFixedColor(i);
            }
        } else if (itemstack.m_150930_((Item)ItemsInit.ITEM_AMETHYST_ARROW.get())) {
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void setFixedColor(int color) {
        this.fixedColor = true;
        this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)color);
    }

    public void m_8119_() {
        super.m_8119_();
        if (this.f_19853_.f_46443_) {
            if (this.f_36703_) {
                if (this.f_36704_ % 5 == 0) {
                    this.makeParticle(1);
                }
            } else {
                this.makeParticle(2);
            }
        } else if (this.f_36703_ && this.f_36704_ != 0 && !this.effects.isEmpty() && this.f_36704_ >= 600) {
            this.f_19853_.m_7605_((Entity)this, (byte)0);
            this.potion = Potions.f_43598_;
            this.effects.clear();
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        }
    }

    private void updateColor() {
        this.fixedColor = false;
        if (this.potion == Potions.f_43598_ && this.effects.isEmpty()) {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)-1);
        } else {
            this.f_19804_.m_135381_(ID_EFFECT_COLOR, (Object)PotionUtils.m_43564_((Collection)PotionUtils.m_43561_((Potion)this.potion, this.effects)));
        }
    }
}

