/*
 * Decompiled with CFR 0.152.
 */
package com.macaronsteam.amethysttoolsmod.init;

import com.google.common.primitives.Booleans;
import com.macaronsteam.amethysttoolsmod.config.AmethystToolsModConfig;
import com.macaronsteam.amethysttoolsmod.item.AmethystArmorMaterial;
import com.macaronsteam.amethysttoolsmod.item.AmethystArrowItem;
import com.macaronsteam.amethysttoolsmod.item.AmethystDispenseBehavior;
import com.macaronsteam.amethysttoolsmod.item.AmethystTridentItem;
import com.macaronsteam.amethysttoolsmod.item.MaterialItem;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.management.RuntimeErrorException;
import net.minecraft.core.dispenser.DispenseItemBehavior;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EquipmentSlot;
import net.minecraft.world.entity.ai.attributes.AttributeModifier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.ArmorItem;
import net.minecraft.world.item.ArmorMaterial;
import net.minecraft.world.item.DiggerItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Rarity;
import net.minecraft.world.item.SwordItem;
import net.minecraft.world.item.Tier;
import net.minecraft.world.item.TieredItem;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.DispenserBlock;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.common.ForgeTier;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.registries.RegistryObject;
import org.apache.logging.log4j.core.util.ReflectionUtil;

public class ItemsInit {
    public static RegistryObject<Item> ITEM_AMETHYST_DUST;
    public static RegistryObject<Item> ITEM_AMETHYST_CLUSTER;
    public static RegistryObject<Item> ITEM_AMETHYST_CLUSTER_LV2;
    public static RegistryObject<Item> ITEM_AMETHYST_ARROW;
    public static RegistryObject<Item> ITEM_AMETHYST_TIPPED_ARROW;
    public static RegistryObject<Item> ITEM_AMETHYST_SPECTRAL_ARROW;
    public static RegistryObject<Item> ITEM_AMETHYST_TRIDENT;
    public static final DeferredRegister<Item> ITEMS;
    public static final Map<ArmorMaterial, ArmorMaterial> MATERIALS_CACHE;
    public static final Map<Tier, Tier> TIERS_CACHE;

    private static ArmorMaterial buildArmorMaterial(ArmorMaterial material) {
        return MATERIALS_CACHE.computeIfAbsent(material, AmethystArmorMaterial::new);
    }

    private static Item.Properties buildProperties(Item input) {
        Item.Properties properties = new Item.Properties().m_41491_(input.m_41471_());
        if (input.m_41475_()) {
            properties.m_41486_();
        }
        return properties;
    }

    private static Tier buildTier(Tier tier) {
        return TIERS_CACHE.computeIfAbsent(tier, key -> new ForgeTier(key.m_6604_(), (int)((double)key.m_6609_() * (Double)AmethystToolsModConfig.durabilityMultiplier.get()), key.m_6624_() + ((Double)AmethystToolsModConfig.extraDigSpeed.get()).floatValue(), key.m_6631_() + ((Double)AmethystToolsModConfig.extraAttackDamage.get()).floatValue(), key.m_6601_() + (Integer)AmethystToolsModConfig.extraEnchantability.get(), key.getTag(), () -> key.m_6282_()));
    }

    private static boolean isItemEnabled(Item input) {
        return Stream.of("Iron", "Diamond", "Netherite").anyMatch(str -> ForgeRegistries.ITEMS.getKey((Object)input).m_135815_().contains(str.toLowerCase()) && (Boolean)((ForgeConfigSpec.BooleanValue)AmethystToolsModConfig.spec.getValues().get("enable" + str)).get() != false);
    }

    public static void register() {
        ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        ItemsInit.registerAmethystEquipment();
        ITEM_AMETHYST_DUST = ItemsInit.register("amethyst_dust", () -> new MaterialItem(), new boolean[0]);
        ITEM_AMETHYST_CLUSTER = ItemsInit.register("amethyst_cluster", () -> new MaterialItem(), new boolean[0]);
        ITEM_AMETHYST_CLUSTER_LV2 = ItemsInit.register("amethyst_cluster_lv2", () -> new MaterialItem(Rarity.UNCOMMON), new boolean[0]);
        ITEM_AMETHYST_ARROW = ItemsInit.register("amethyst_arrow", () -> new AmethystArrowItem(), (Boolean)AmethystToolsModConfig.enableAmethystArrows.get());
        ITEM_AMETHYST_TIPPED_ARROW = ItemsInit.register("amethyst_tipped_arrow", () -> new AmethystArrowItem.TippedItem(), (Boolean)AmethystToolsModConfig.enableAmethystArrows.get(), (Boolean)AmethystToolsModConfig.enableExtraArrows.get());
        ITEM_AMETHYST_SPECTRAL_ARROW = ItemsInit.register("amethyst_spectral_arrow", () -> new AmethystArrowItem.SpectralItem(), (Boolean)AmethystToolsModConfig.enableAmethystArrows.get(), (Boolean)AmethystToolsModConfig.enableExtraArrows.get());
        ITEM_AMETHYST_TRIDENT = ItemsInit.register("amethyst_trident", () -> new AmethystTridentItem(), (Boolean)AmethystToolsModConfig.enableAmethystTrident.get());
    }

    public static RegistryObject<Item> register(String name, Supplier item, boolean ... condition) {
        if (!Booleans.contains((boolean[])condition, (boolean)false) && name != null && item != null) {
            return ITEMS.register(name, item);
        }
        return (RegistryObject)ReflectionUtil.instantiate(RegistryObject.class);
    }

    public static void registerAmethystEquipment() {
        String[] types = new String[]{"sword", "pickaxe", "axe", "shovel", "hoe", "boots", "leggings", "chestplate", "helmet"};
        List list = Stream.of("iron", "diamond", "netherite").flatMap(str -> {
            String[] arr = new String[types.length];
            IntStream.range(0, types.length).forEach(i -> {
                arr[i] = String.join((CharSequence)"_", str, types[i]);
            });
            return Stream.of(arr);
        }).map(name -> (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(name))).collect(Collectors.toList());
        list.stream().filter(ItemsInit::isItemEnabled).forEach(item -> ItemsInit.register(ForgeRegistries.ITEMS.getKey(item).m_135815_() + "_amethyst", () -> ItemsInit.tryToCreate(item), new boolean[0]));
    }

    public static void registerBehavior() {
        AmethystDispenseBehavior behavior = new AmethystDispenseBehavior();
        ITEM_AMETHYST_ARROW.ifPresent(item -> DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)behavior));
        ITEM_AMETHYST_TIPPED_ARROW.ifPresent(item -> DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)behavior));
        ITEM_AMETHYST_SPECTRAL_ARROW.ifPresent(item -> DispenserBlock.m_52672_((ItemLike)item, (DispenseItemBehavior)behavior));
    }

    public static Item tryToCreate(Item input) {
        if (input instanceof ArmorItem) {
            ArmorItem iof = (ArmorItem)input;
            return new ArmorItem(ItemsInit.buildArmorMaterial(iof.m_40401_()), iof.m_40402_(), ItemsInit.buildProperties(input)){

                @OnlyIn(value=Dist.CLIENT)
                public String getArmorTexture(ItemStack stack, Entity entity, EquipmentSlot slot, String type) {
                    return "amethysttoolsmod:textures/models/" + this.m_40401_().m_6082_() + "_layer_" + (slot != EquipmentSlot.LEGS ? 1 : 2) + ".png";
                }
            };
        }
        if (input instanceof TieredItem) {
            float f;
            TieredItem iof = (TieredItem)input;
            if (iof instanceof DiggerItem) {
                DiggerItem iof1 = (DiggerItem)iof;
                f = iof1.m_41008_();
            } else {
                f = ((SwordItem)iof).m_43299_();
            }
            Number attackDamage = Float.valueOf(f - iof.m_43314_().m_6631_());
            Constructor<?> constructor = input.getClass().getDeclaredConstructors()[0];
            if (constructor.getParameterTypes()[1] == Integer.TYPE) {
                attackDamage = attackDamage.intValue();
            }
            try {
                return (Item)constructor.newInstance(ItemsInit.buildTier(iof.m_43314_()), attackDamage, Float.valueOf((float)((AttributeModifier[])input.m_7968_().m_41638_(EquipmentSlot.MAINHAND).get((Object)Attributes.f_22283_).toArray(AttributeModifier[]::new))[0].m_22218_()), ItemsInit.buildProperties(input));
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException | InvocationTargetException exception) {
                throw new RuntimeErrorException(new Error(input + " instantination by reflection had failed"));
            }
        }
        return null;
    }

    static {
        ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"amethysttoolsmod");
        MATERIALS_CACHE = new HashMap<ArmorMaterial, ArmorMaterial>();
        TIERS_CACHE = new HashMap<Tier, Tier>();
    }
}

