/*
 * Decompiled with CFR 0.152.
 */
package com.macaronsteam.amethysttoolsmod.lootmodifiers;

import com.google.common.base.Suppliers;
import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import it.unimi.dsi.fastutil.objects.ObjectArrayList;
import java.util.List;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.storage.loot.LootContext;
import net.minecraft.world.level.storage.loot.predicates.LootItemCondition;
import net.minecraftforge.common.loot.IGlobalLootModifier;
import net.minecraftforge.common.loot.LootModifier;
import net.minecraftforge.registries.ForgeRegistries;

public class LootModifierAdd
extends LootModifier {
    public static final Supplier<Codec<LootModifierAdd>> CODEC = Suppliers.memoize(() -> RecordCodecBuilder.create(inst -> LootModifier.codecStart((RecordCodecBuilder.Instance)inst).and(inst.group((App)Codec.list((Codec)Codec.STRING).fieldOf("lootTables").forGetter(m -> m.targetLootTables), (App)ForgeRegistries.ITEMS.getCodec().fieldOf("item").forGetter(m -> m.itemToAdd), (App)Codec.INT.fieldOf("minCount").forGetter(m -> m.minStackCount), (App)Codec.INT.fieldOf("maxCount").forGetter(m -> m.maxStackCount))).apply((Applicative)inst, LootModifierAdd::new)));
    public final Item itemToAdd;
    public final int maxStackCount;
    public final int minStackCount;
    public final List<String> targetLootTables;

    public LootModifierAdd(LootItemCondition[] conditionsIn, List<String> lootTables, Item itemToAdd, int minStackCount, int maxStackCount) {
        super(conditionsIn);
        this.targetLootTables = lootTables;
        this.itemToAdd = itemToAdd;
        this.maxStackCount = maxStackCount;
        this.minStackCount = minStackCount;
    }

    protected ObjectArrayList<ItemStack> doApply(ObjectArrayList<ItemStack> generatedLoot, LootContext context) {
        List lootTables = this.targetLootTables.stream().map(lootTable -> new ResourceLocation(lootTable)).collect(Collectors.toList());
        if (lootTables.contains(context.getQueriedLootTableId())) {
            ItemStack stack = new ItemStack((ItemLike)this.itemToAdd, context.m_230907_().m_216339_(this.minStackCount, this.maxStackCount + 1));
            generatedLoot.add((Object)stack);
        }
        return generatedLoot;
    }

    public Codec<? extends IGlobalLootModifier> codec() {
        return CODEC.get();
    }
}

