/*
 * Decompiled with CFR 0.152.
 */
package com.crispytwig.another_furniture.block;

import com.crispytwig.another_furniture.block.BaseEntityBlock;
import com.crispytwig.another_furniture.block.entity.ShelfBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class ShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = HorizontalDirectionalBlock.f_54117_;
    public static final IntegerProperty TYPE = IntegerProperty.m_61631_((String)"type", (int)0, (int)3);
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NL = Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape NR = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)14.0, (double)16.0);
    protected static final VoxelShape EL = Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)10.0, (double)14.0, (double)16.0);
    protected static final VoxelShape ER = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)10.0, (double)14.0, (double)4.0);
    protected static final VoxelShape SL = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)4.0, (double)14.0, (double)10.0);
    protected static final VoxelShape SR = Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)10.0);
    protected static final VoxelShape WL = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)4.0);
    protected static final VoxelShape WR = Block.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape T_NL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)NL);
    protected static final VoxelShape T_NR = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)NR);
    protected static final VoxelShape T_NLR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{NL, NR});
    protected static final VoxelShape T_EL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)EL);
    protected static final VoxelShape T_ER = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)ER);
    protected static final VoxelShape T_ELR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{EL, ER});
    protected static final VoxelShape T_SL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)SL);
    protected static final VoxelShape T_SR = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)SR);
    protected static final VoxelShape T_SLR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{SL, SR});
    protected static final VoxelShape T_WL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)WL);
    protected static final VoxelShape T_WR = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)WR);
    protected static final VoxelShape T_WLR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{WL, WR});

    public ShelfBlock(BlockBehaviour.Properties p_49795_) {
        super(p_49795_);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_((Property)TYPE, (Comparable)Integer.valueOf(0))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        BlockEntity blockentity;
        if (hit.m_82434_() == Direction.UP && (blockentity = level.m_7702_(pos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfblockentity = (ShelfBlockEntity)blockentity;
            ItemStack itemstack = player.m_21120_(hand);
            if (!itemstack.m_41619_()) {
                if (!level.f_46443_ && shelfblockentity.placeItem(player.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack, this.getPosition(hit, pos))) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (!level.f_46443_ && shelfblockentity.removeItem(this.getPosition(hit, pos))) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState p_51281_, Level p_51282_, BlockPos p_51283_, BlockState p_51284_, boolean p_51285_) {
        if (!p_51281_.m_60713_(p_51284_.m_60734_())) {
            BlockEntity blockentity = p_51282_.m_7702_(p_51283_);
            if (blockentity instanceof ShelfBlockEntity) {
                Containers.m_19010_((Level)p_51282_, (BlockPos)p_51283_, ((ShelfBlockEntity)blockentity).getItems());
            }
            super.m_6810_(p_51281_, p_51282_, p_51283_, p_51284_, p_51285_);
        }
    }

    public boolean m_7923_(BlockState p_60576_) {
        return true;
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter blockGetter, BlockPos pos, CollisionContext ctx) {
        Direction direction = (Direction)state.m_61143_((Property)FACING);
        int type = (Integer)state.m_61143_((Property)TYPE);
        if (direction == Direction.NORTH) {
            return switch (type) {
                case 0 -> T_NLR;
                case 1 -> T_NL;
                case 3 -> T_NR;
                default -> TOP;
            };
        }
        if (direction == Direction.EAST) {
            return switch (type) {
                case 0 -> T_ELR;
                case 1 -> T_EL;
                case 3 -> T_ER;
                default -> TOP;
            };
        }
        if (direction == Direction.SOUTH) {
            return switch (type) {
                case 0 -> T_SLR;
                case 1 -> T_SL;
                case 3 -> T_SR;
                default -> TOP;
            };
        }
        if (direction == Direction.WEST) {
            return switch (type) {
                case 0 -> T_WLR;
                case 1 -> T_WL;
                case 3 -> T_WR;
                default -> TOP;
            };
        }
        return TOP;
    }

    @Override
    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext ctx) {
        boolean waterlogged = ctx.m_43725_().m_6425_(ctx.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)ctx.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState state, Direction direction, BlockState newState, LevelAccessor level, BlockPos pos, BlockPos newPos) {
        BlockEntity blockentity;
        if (((Boolean)state.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            level.m_186469_(pos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        if (level.m_8055_(pos.m_7494_()).m_60783_((BlockGetter)level, pos, Direction.DOWN) && (blockentity = level.m_7702_(pos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfblockentity = (ShelfBlockEntity)blockentity;
            shelfblockentity.removeAllItems();
        }
        Direction facing = (Direction)state.m_61143_((Property)FACING);
        BlockState l_state = level.m_8055_(pos.m_142300_(facing.m_122427_()));
        BlockState r_state = level.m_8055_(pos.m_142300_(facing.m_122428_()));
        boolean l_side = l_state.m_60734_() instanceof ShelfBlock && l_state.m_61143_((Property)FACING) == facing;
        boolean r_side = r_state.m_60734_() instanceof ShelfBlock && r_state.m_61143_((Property)FACING) == facing;
        int type = 0;
        if (l_side && r_side) {
            type = 2;
        } else if (r_side) {
            type = 1;
        } else if (l_side) {
            type = 3;
        }
        return (BlockState)state.m_61124_((Property)TYPE, (Comparable)Integer.valueOf(type));
    }

    public FluidState m_5888_(BlockState p_52362_) {
        return (Boolean)p_52362_.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(p_52362_);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public BlockEntity m_142194_(BlockPos p_152759_, BlockState p_152760_) {
        return new ShelfBlockEntity(p_152759_, p_152760_);
    }

    private int getPosition(BlockHitResult hit, BlockPos pos) {
        Vec3 hitVec = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        int position = 0;
        if (hitVec.m_7096_() > 0.5) {
            ++position;
        }
        if (hitVec.m_7094_() > 0.5) {
            position += 2;
        }
        return position;
    }

    public BlockState m_6843_(BlockState state, Rotation rot) {
        return (BlockState)state.m_61124_((Property)FACING, (Comparable)rot.m_55954_((Direction)state.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState state, Mirror mirror) {
        return state.m_60717_(mirror.m_54846_((Direction)state.m_61143_((Property)FACING)));
    }
}

