/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.entity.PlanterBoxBlockEntity;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFItemTags;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class PlanterBoxBlock
extends BaseEntityBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final BooleanProperty ATTACHED = BlockStateProperties.f_61386_;
    protected static final VoxelShape NORTH_AABB = Block.m_49796_((double)0.0, (double)10.0, (double)8.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_AABB = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)8.0);
    protected static final VoxelShape WEST_AABB = Block.m_49796_((double)8.0, (double)10.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape EAST_AABB = Block.m_49796_((double)0.0, (double)10.0, (double)0.0, (double)8.0, (double)16.0, (double)16.0);
    protected static final VoxelShape Z_AXIS_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)4.0, (double)16.0, (double)6.0, (double)12.0);
    protected static final VoxelShape X_AXIS_AABB = Block.m_49796_((double)4.0, (double)0.0, (double)0.0, (double)12.0, (double)6.0, (double)16.0);

    public PlanterBoxBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        boolean attached = (Boolean)pState.m_61143_((Property)ATTACHED);
        switch ((Direction)pState.m_61143_((Property)FACING)) {
            case WEST: {
                return attached ? WEST_AABB : X_AXIS_AABB;
            }
            case EAST: {
                return attached ? EAST_AABB : X_AXIS_AABB;
            }
            case SOUTH: {
                return attached ? SOUTH_AABB : Z_AXIS_AABB;
            }
        }
        return attached ? NORTH_AABB : Z_AXIS_AABB;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRot) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRot.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        if (((Boolean)state.m_61143_((Property)ATTACHED)).booleanValue()) {
            Direction direction = (Direction)state.m_61143_((Property)FACING);
            BlockPos facingPos = pos.m_142300_(direction.m_122424_());
            BlockState facingState = level.m_8055_(facingPos);
            return facingState.m_60783_((BlockGetter)level, facingPos, direction);
        }
        return super.m_7898_(state, level, pos);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        boolean r_side;
        boolean attached = (Boolean)pState.m_61143_((Property)ATTACHED);
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        if (attached && pDirection.m_122424_() == facing && !pState.m_60710_((LevelReader)pLevel, pCurrentPos)) {
            return Blocks.f_50016_.m_49966_();
        }
        BlockState l_state = pLevel.m_8055_(pCurrentPos.m_142300_(facing.m_122427_()));
        BlockState r_state = pLevel.m_8055_(pCurrentPos.m_142300_(facing.m_122428_()));
        boolean l_side = l_state.m_60734_() instanceof PlanterBoxBlock && (Boolean)l_state.m_61143_((Property)ATTACHED) == attached && (l_state.m_61143_((Property)FACING) == facing || !attached && l_state.m_61143_((Property)FACING) == facing.m_122424_());
        boolean bl = r_side = r_state.m_60734_() instanceof PlanterBoxBlock && (Boolean)r_state.m_61143_((Property)ATTACHED) == attached && (r_state.m_61143_((Property)FACING) == facing || !attached && r_state.m_61143_((Property)FACING) == facing.m_122424_());
        HorizontalConnectionType type = l_side && r_side ? HorizontalConnectionType.MIDDLE : (r_side ? HorizontalConnectionType.LEFT : (l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)pState.m_61124_(TYPE, (Comparable)((Object)type));
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        Direction clickedFace = pContext.m_43719_();
        boolean attached = clickedFace != Direction.UP && clickedFace != Direction.DOWN;
        Direction facing = attached ? clickedFace : pContext.m_8125_().m_122424_();
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)ATTACHED, (Comparable)Boolean.valueOf(attached))).m_61124_((Property)FACING, (Comparable)facing);
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, TYPE, ATTACHED});
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new PlanterBoxBlockEntity(pPos, pState);
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockEntity = pLevel.m_7702_(pPos);
        if (blockEntity instanceof PlanterBoxBlockEntity) {
            boolean slot_0;
            PlanterBoxBlockEntity planterBoxBlockEntity = (PlanterBoxBlockEntity)blockEntity;
            ItemStack stack = pPlayer.m_21120_(pHand);
            Direction facing = (Direction)pState.m_61143_((Property)FACING);
            if (facing.m_122434_() == Direction.Axis.X) {
                slot_0 = pHit.m_82450_().f_82481_ - (double)pHit.m_82425_().m_123343_() > 0.5;
            } else {
                boolean bl = slot_0 = pHit.m_82450_().f_82479_ - (double)pHit.m_82425_().m_123341_() > 0.5;
            }
            if (facing == Direction.SOUTH || facing == Direction.WEST) {
                boolean bl = slot_0 = !slot_0;
            }
            if (stack.m_204117_(AFItemTags.PLANTER_BOX_PLACEABLES) && !stack.m_204117_(AFItemTags.PLANTER_BOX_BANNED)) {
                if (!pLevel.f_46443_ && planterBoxBlockEntity.placeFlower(pPlayer.m_150110_().f_35937_ ? stack.m_41777_() : stack, slot_0 ? 0 : 1)) {
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockEntity = pLevel.m_7702_(pPos);
            if (blockEntity instanceof PlanterBoxBlockEntity) {
                PlanterBoxBlockEntity planterBoxBlockEntity = (PlanterBoxBlockEntity)blockEntity;
                Containers.m_19010_((Level)pLevel, (BlockPos)pPos, planterBoxBlockEntity.getItems());
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public boolean m_7357_(BlockState pState, BlockGetter pLevel, BlockPos pPos, PathComputationType pType) {
        return false;
    }
}

