/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.block.properties.ShutterType;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShutterBlock
extends Block
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<ShutterType> TYPE = ModBlockStateProperties.SHUTTER_TYPE;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty LEFT = BooleanProperty.m_61465_((String)"left");
    public static final BooleanProperty POWERED = BlockStateProperties.f_61448_;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape[] SHAPES = new VoxelShape[]{SOUTH, WEST, NORTH, EAST};

    public ShutterBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)ShutterType.NONE))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(false))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(false))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        int shape = ((Direction)pState.m_61143_((Property)FACING)).m_122416_() + (((Boolean)pState.m_61143_((Property)OPEN)).booleanValue() ? (((Boolean)pState.m_61143_((Property)LEFT)).booleanValue() ? 3 : 1) : 0);
        return SHAPES[shape % 4];
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        boolean left;
        BlockState blockstate = this.m_49966_();
        Direction facing = pContext.m_8125_().m_122424_();
        blockstate = (BlockState)blockstate.m_61124_((Property)FACING, (Comparable)facing);
        if (facing.m_122434_() == Direction.Axis.X) {
            left = pContext.m_43720_().f_82481_ - (double)pContext.m_8083_().m_123343_() > 0.5;
        } else {
            boolean bl = left = pContext.m_43720_().f_82479_ - (double)pContext.m_8083_().m_123341_() > 0.5;
        }
        if (pContext.m_8125_() == Direction.NORTH || pContext.m_8125_() == Direction.EAST) {
            left = !left;
        }
        blockstate = (BlockState)blockstate.m_61124_((Property)LEFT, (Comparable)Boolean.valueOf(left));
        if (pContext.m_43725_().m_46753_(pContext.m_8083_())) {
            blockstate = (BlockState)((BlockState)blockstate.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(true));
        }
        blockstate = (BlockState)blockstate.m_61124_(TYPE, (Comparable)((Object)this.getType(blockstate, pContext.m_43725_().m_8055_(pContext.m_8083_().m_7494_()), pContext.m_43725_().m_8055_(pContext.m_8083_().m_7495_()))));
        return (BlockState)blockstate.m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_));
    }

    public void m_6861_(BlockState pState, Level pLevel, BlockPos pPos, Block pBlock, BlockPos pFromPos, boolean pIsMoving) {
        if (!pLevel.f_46443_) {
            boolean powered = pLevel.m_46753_(pPos);
            if (powered != (Boolean)pState.m_61143_((Property)POWERED)) {
                if ((Boolean)pState.m_61143_((Property)OPEN) != powered) {
                    pState = (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(powered));
                    pLevel.m_5594_(null, pPos, this.shutterSound(powered), SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                if (((Boolean)(pState = (BlockState)pState.m_61124_((Property)POWERED, (Comparable)Boolean.valueOf(powered))).m_61143_((Property)WATERLOGGED)).booleanValue()) {
                    pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
                }
            }
            ShutterType type = this.getType(pState, pLevel.m_8055_(pPos.m_7494_()), pLevel.m_8055_(pPos.m_7495_()));
            if (pState.m_61143_(TYPE) != type) {
                pState = (BlockState)pState.m_61124_(TYPE, (Comparable)((Object)type));
            }
            pLevel.m_7731_(pPos, pState, 3);
        }
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        if (this.f_60442_ == Material.f_76279_) {
            return InteractionResult.PASS;
        }
        pState = (BlockState)pState.m_61122_((Property)OPEN);
        pLevel.m_7731_(pPos, pState, 3);
        if (!pPlayer.m_6047_()) {
            this.toggleShutters(pState, pLevel, pPos, (Boolean)pState.m_61143_((Property)OPEN));
        }
        pLevel.m_5594_(null, pPos, this.shutterSound((Boolean)pState.m_61143_((Property)OPEN)), SoundSource.BLOCKS, 1.0f, 1.0f);
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public void toggleShutters(BlockState state, Level level, BlockPos pos, boolean open) {
        int i;
        BlockState updateState = state;
        BlockPos updatePos = pos;
        if (state.m_61143_(TYPE) == ShutterType.MIDDLE || state.m_61143_(TYPE) == ShutterType.BOTTOM) {
            BlockState above;
            int heightUp = level.m_6042_().m_156733_() - updatePos.m_123342_();
            for (i = 0; i < heightUp && (above = level.m_8055_(updatePos.m_7494_())).m_60713_(state.m_60734_()) && above.m_61143_((Property)FACING) == updateState.m_61143_((Property)FACING) && above.m_61143_((Property)LEFT) == updateState.m_61143_((Property)LEFT) && (Boolean)above.m_61143_((Property)OPEN) != open; ++i) {
                updateState = above;
                updatePos = updatePos.m_7494_();
                level.m_7731_(updatePos, (BlockState)updateState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
        if (state.m_61143_(TYPE) == ShutterType.MIDDLE || state.m_61143_(TYPE) == ShutterType.TOP) {
            BlockState below;
            updateState = state;
            updatePos = pos;
            int heightDown = level.m_6042_().m_156732_() - updatePos.m_123342_();
            heightDown = heightDown < 0 ? -heightDown : heightDown;
            for (i = 0; i < heightDown && (below = level.m_8055_(updatePos.m_7495_())).m_60713_(state.m_60734_()) && below.m_61143_((Property)FACING) == updateState.m_61143_((Property)FACING) && below.m_61143_((Property)LEFT) == updateState.m_61143_((Property)LEFT) && (Boolean)below.m_61143_((Property)OPEN) != open; ++i) {
                updateState = below;
                updatePos = updatePos.m_7495_();
                level.m_7731_(updatePos, (BlockState)updateState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 3);
            }
        }
    }

    public SoundEvent shutterSound(boolean open) {
        if (open) {
            return SoundEvents.f_12629_;
        }
        return SoundEvents.f_12628_;
    }

    public ShutterType getType(BlockState state, BlockState above, BlockState below) {
        boolean shape_below_same;
        boolean shape_above_same = above.m_60713_(state.m_60734_()) && above.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && above.m_61143_((Property)OPEN) == state.m_61143_((Property)OPEN) && above.m_61143_((Property)LEFT) == state.m_61143_((Property)LEFT);
        boolean bl = shape_below_same = below.m_60713_(state.m_60734_()) && below.m_61143_((Property)FACING) == state.m_61143_((Property)FACING) && below.m_61143_((Property)OPEN) == state.m_61143_((Property)OPEN) && below.m_61143_((Property)LEFT) == state.m_61143_((Property)LEFT);
        if (shape_above_same && !shape_below_same) {
            return ShutterType.BOTTOM;
        }
        if (!shape_above_same && shape_below_same) {
            return ShutterType.TOP;
        }
        if (shape_above_same) {
            return ShutterType.MIDDLE;
        }
        return ShutterType.NONE;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, TYPE, OPEN, LEFT, POWERED, WATERLOGGED});
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        return super.m_7417_(pState, pDirection, pNeighborState, pLevel, pCurrentPos, pNeighborPos);
    }
}

