/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.entity.CurtainBlockEntity;
import com.starfish_studios.another_furniture.block.properties.CurtainType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import com.starfish_studios.another_furniture.registry.AFSoundEvents;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.material.PushReaction;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CurtainBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<CurtainType> TYPE = ModBlockStateProperties.CURTAIN_TYPE;
    public static final BooleanProperty OPEN = BlockStateProperties.f_61446_;
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)2.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST = Block.m_49796_((double)14.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    protected static final VoxelShape NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)14.0, (double)16.0, (double)16.0, (double)16.0);
    private final DyeColor color;

    public CurtainBlock(DyeColor color, BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)CurtainType.LEFT))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(true))).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
        this.color = color;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return switch ((Direction)pState.m_61143_((Property)FACING)) {
            case Direction.EAST -> EAST;
            case Direction.SOUTH -> SOUTH;
            case Direction.WEST -> WEST;
            default -> NORTH;
        };
    }

    public VoxelShape m_5939_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        return (Boolean)pState.m_61143_((Property)OPEN) != false ? Shapes.m_83040_() : super.m_5939_(pState, pLevel, pPos, pContext);
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        CurtainType type;
        Direction direction = pContext.m_8125_().m_122424_();
        BlockPos blockpos = pContext.m_8083_();
        BlockPos below = blockpos.m_7495_();
        Level level = pContext.m_43725_();
        if (direction.m_122434_() == Direction.Axis.X) {
            type = pContext.m_43720_().f_82481_ - (double)pContext.m_8083_().m_123343_() > 0.5 ? CurtainType.RIGHT : CurtainType.LEFT;
        } else {
            CurtainType curtainType = type = pContext.m_43720_().f_82479_ - (double)pContext.m_8083_().m_123341_() > 0.5 ? CurtainType.RIGHT : CurtainType.LEFT;
        }
        if (pContext.m_8125_() == Direction.NORTH || pContext.m_8125_() == Direction.EAST) {
            type = type == CurtainType.LEFT ? CurtainType.RIGHT : CurtainType.LEFT;
        }
        return level.m_8055_(below).m_60629_(pContext) ? (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)direction)).m_61124_(TYPE, (Comparable)((Object)type)) : null;
    }

    public void m_6402_(Level pLevel, BlockPos pPos, BlockState pState, @Nullable LivingEntity pPlacer, ItemStack pStack) {
        boolean rr_side;
        super.m_6402_(pLevel, pPos, pState, pPlacer, pStack);
        if (pLevel.f_46443_) {
            return;
        }
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        CurtainType type = (CurtainType)((Object)pState.m_61143_(TYPE));
        BlockState l_state = pLevel.m_8055_(pPos.m_121945_(facing.m_122427_()));
        BlockState r_state = pLevel.m_8055_(pPos.m_121945_(facing.m_122428_()));
        boolean l_side = l_state.m_60734_() instanceof CurtainBlock && l_state.m_61143_((Property)FACING) == facing;
        boolean r_side = r_state.m_60734_() instanceof CurtainBlock && r_state.m_61143_((Property)FACING) == facing;
        BlockState ll_state = pLevel.m_8055_(pPos.m_5484_(facing.m_122427_(), 2));
        BlockState rr_state = pLevel.m_8055_(pPos.m_5484_(facing.m_122428_(), 2));
        boolean ll_side = ll_state.m_60734_() instanceof CurtainBlock && ll_state.m_61143_((Property)FACING) == facing;
        boolean bl = rr_side = rr_state.m_60734_() instanceof CurtainBlock && rr_state.m_61143_((Property)FACING) == facing;
        if (type == CurtainType.RIGHT && l_side && ll_side && l_state.m_61143_(TYPE) == CurtainType.RIGHT && ll_state.m_61143_(TYPE) == CurtainType.LEFT) {
            pLevel.m_46597_(pPos.m_121945_(facing.m_122427_()), (BlockState)l_state.m_61124_(TYPE, (Comparable)((Object)CurtainType.MIDDLE)));
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)OPEN, (Comparable)((Boolean)l_state.m_61143_((Property)OPEN))), 2);
        } else if (type == CurtainType.LEFT && r_side && rr_side && r_state.m_61143_(TYPE) == CurtainType.LEFT && rr_state.m_61143_(TYPE) == CurtainType.RIGHT) {
            pLevel.m_46597_(pPos.m_121945_(facing.m_122428_()), (BlockState)r_state.m_61124_(TYPE, (Comparable)((Object)CurtainType.MIDDLE)));
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)OPEN, (Comparable)((Boolean)r_state.m_61143_((Property)OPEN))), 2);
        }
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        boolean rSide;
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        CurtainType type = (CurtainType)((Object)pState.m_61143_(TYPE));
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        BlockState lState = pLevel.m_8055_(pCurrentPos.m_121945_(facing.m_122427_()));
        BlockState rState = pLevel.m_8055_(pCurrentPos.m_121945_(facing.m_122428_()));
        boolean lSide = lState.m_60734_() instanceof CurtainBlock && lState.m_61143_((Property)FACING) == facing;
        boolean bl = rSide = rState.m_60734_() instanceof CurtainBlock && rState.m_61143_((Property)FACING) == facing;
        if (!(type != CurtainType.MIDDLE || lSide && lState.m_61143_(TYPE) == CurtainType.LEFT && rSide && rState.m_61143_(TYPE) == CurtainType.RIGHT)) {
            pState = lSide && lState.m_61143_(TYPE) == CurtainType.LEFT ? (BlockState)pState.m_61124_(TYPE, (Comparable)((Object)CurtainType.RIGHT)) : (BlockState)pState.m_61124_(TYPE, (Comparable)((Object)CurtainType.LEFT));
        }
        return pState;
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        pState = (BlockState)pState.m_61122_((Property)OPEN);
        boolean open = (Boolean)pState.m_61143_((Property)OPEN);
        boolean top = (Boolean)pState.m_61143_((Property)TOP);
        CurtainType type = (CurtainType)((Object)pState.m_61143_(TYPE));
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        BlockPos startpos = pPos;
        int times = 1;
        if (type == CurtainType.MIDDLE) {
            times = 3;
            startpos = pPos.m_121945_(facing.m_122427_());
        } else if (type == CurtainType.RIGHT) {
            BlockState left = pLevel.m_8055_(startpos.m_121945_(facing.m_122427_()));
            if (left.m_60734_() instanceof CurtainBlock && left.m_61143_(TYPE) == CurtainType.MIDDLE && (Boolean)left.m_61143_((Property)TOP) == top && left.m_61143_((Property)FACING) == facing) {
                times = 3;
                startpos = pPos.m_5484_(facing.m_122427_(), 2);
            } else if (left.m_60734_() instanceof CurtainBlock && left.m_61143_(TYPE) == CurtainType.LEFT && (Boolean)left.m_61143_((Property)TOP) == top && left.m_61143_((Property)FACING) == facing) {
                times = 2;
                startpos = pPos.m_121945_(facing.m_122427_());
            }
        } else {
            BlockState right = pLevel.m_8055_(startpos.m_121945_(facing.m_122428_()));
            if (right.m_60734_() instanceof CurtainBlock && right.m_61143_(TYPE) == CurtainType.MIDDLE && (Boolean)right.m_61143_((Property)TOP) == top && right.m_61143_((Property)FACING) == facing) {
                times = 3;
            } else if (right.m_60734_() instanceof CurtainBlock && right.m_61143_(TYPE) == CurtainType.RIGHT && (Boolean)right.m_61143_((Property)TOP) == top && right.m_61143_((Property)FACING) == facing) {
                times = 2;
            }
        }
        for (int i = 0; i < times; ++i) {
            BlockState newstate = pLevel.m_8055_(startpos);
            if (newstate.m_60734_() instanceof CurtainBlock) {
                pLevel.m_7731_(startpos, (BlockState)newstate.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(open)), 2);
            }
            startpos = startpos.m_121945_(facing.m_122428_());
        }
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        pLevel.m_5594_(null, pPos, AFSoundEvents.CURTAIN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
        return InteractionResult.m_19078_((boolean)pLevel.f_46443_);
    }

    public PushReaction m_5537_(BlockState pState) {
        return PushReaction.DESTROY;
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, TYPE, OPEN, TOP, WATERLOGGED});
    }

    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new CurtainBlockEntity(pPos, pState);
    }

    public FluidState m_5888_(BlockState pState) {
        return (Boolean)pState.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(pState);
    }

    public RenderShape m_7514_(BlockState pState) {
        return RenderShape.MODEL;
    }

    public String getColor() {
        return this.color.toString();
    }
}

