/*
 * Decompiled with CFR 0.152.
 */
package com.starfish_studios.another_furniture.block;

import com.starfish_studios.another_furniture.block.entity.ShelfBlockEntity;
import com.starfish_studios.another_furniture.block.properties.HorizontalConnectionType;
import com.starfish_studios.another_furniture.block.properties.ModBlockStateProperties;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Mirror;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.Rotation;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.DirectionProperty;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.pathfinder.PathComputationType;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.Nullable;

public class ShelfBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final DirectionProperty FACING = BlockStateProperties.f_61374_;
    public static final EnumProperty<HorizontalConnectionType> TYPE = ModBlockStateProperties.HORIZONTAL_CONNECTION_TYPE;
    public static final BooleanProperty WATERLOGGED = BlockStateProperties.f_61362_;
    protected static final VoxelShape TOP = Block.m_49796_((double)0.0, (double)14.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape NL = Block.m_49796_((double)12.0, (double)6.0, (double)6.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape NR = Block.m_49796_((double)0.0, (double)6.0, (double)6.0, (double)4.0, (double)14.0, (double)16.0);
    protected static final VoxelShape EL = Block.m_49796_((double)0.0, (double)6.0, (double)12.0, (double)10.0, (double)14.0, (double)16.0);
    protected static final VoxelShape ER = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)10.0, (double)14.0, (double)4.0);
    protected static final VoxelShape SL = Block.m_49796_((double)0.0, (double)6.0, (double)0.0, (double)4.0, (double)14.0, (double)10.0);
    protected static final VoxelShape SR = Block.m_49796_((double)12.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)10.0);
    protected static final VoxelShape WL = Block.m_49796_((double)6.0, (double)6.0, (double)0.0, (double)16.0, (double)14.0, (double)4.0);
    protected static final VoxelShape WR = Block.m_49796_((double)6.0, (double)6.0, (double)12.0, (double)16.0, (double)14.0, (double)16.0);
    protected static final VoxelShape T_NL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)NL);
    protected static final VoxelShape T_NR = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)NR);
    protected static final VoxelShape T_NLR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{NL, NR});
    protected static final VoxelShape T_EL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)EL);
    protected static final VoxelShape T_ER = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)ER);
    protected static final VoxelShape T_ELR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{EL, ER});
    protected static final VoxelShape T_SL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)SL);
    protected static final VoxelShape T_SR = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)SR);
    protected static final VoxelShape T_SLR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{SL, SR});
    protected static final VoxelShape T_WL = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)WL);
    protected static final VoxelShape T_WR = Shapes.m_83110_((VoxelShape)TOP, (VoxelShape)WR);
    protected static final VoxelShape T_WLR = Shapes.m_83124_((VoxelShape)TOP, (VoxelShape[])new VoxelShape[]{WL, WR});

    public ShelfBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)FACING, (Comparable)Direction.NORTH)).m_61124_(TYPE, (Comparable)((Object)HorizontalConnectionType.SINGLE))).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(false)));
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pHit) {
        BlockEntity blockentity;
        if (pHit.m_82434_() == Direction.UP && (blockentity = pLevel.m_7702_(pPos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfblockentity = (ShelfBlockEntity)blockentity;
            ItemStack itemstack = pPlayer.m_21120_(pHand);
            if (!itemstack.m_41619_()) {
                if (!pLevel.f_46443_ && shelfblockentity.placeItem(pPlayer.m_150110_().f_35937_ ? itemstack.m_41777_() : itemstack, this.getPosition(pHit, pPos))) {
                    pLevel.m_5594_(null, pPos, SoundEvents.f_12013_, SoundSource.BLOCKS, 1.0f, 1.0f);
                    return InteractionResult.SUCCESS;
                }
                return InteractionResult.CONSUME;
            }
            if (!pLevel.f_46443_ && shelfblockentity.removeItem(this.getPosition(pHit, pPos), pPlayer)) {
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.PASS;
    }

    public void m_6810_(BlockState pState, Level pLevel, BlockPos pPos, BlockState pNewState, boolean pIsMoving) {
        if (!pState.m_60713_(pNewState.m_60734_())) {
            BlockEntity blockentity = pLevel.m_7702_(pPos);
            if (blockentity instanceof ShelfBlockEntity) {
                Containers.m_19010_((Level)pLevel, (BlockPos)pPos, ((ShelfBlockEntity)blockentity).getItems());
            }
            super.m_6810_(pState, pLevel, pPos, pNewState, pIsMoving);
        }
    }

    public boolean m_7923_(BlockState pState) {
        return true;
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        Direction direction = (Direction)pState.m_61143_((Property)FACING);
        HorizontalConnectionType type = (HorizontalConnectionType)((Object)pState.m_61143_(TYPE));
        if (direction == Direction.NORTH) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_NLR;
                case HorizontalConnectionType.LEFT -> T_NL;
                case HorizontalConnectionType.RIGHT -> T_NR;
                default -> TOP;
            };
        }
        if (direction == Direction.EAST) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_ELR;
                case HorizontalConnectionType.LEFT -> T_EL;
                case HorizontalConnectionType.RIGHT -> T_ER;
                default -> TOP;
            };
        }
        if (direction == Direction.SOUTH) {
            return switch (type) {
                case HorizontalConnectionType.SINGLE -> T_SLR;
                case HorizontalConnectionType.LEFT -> T_SL;
                case HorizontalConnectionType.RIGHT -> T_SR;
                default -> TOP;
            };
        }
        return switch (type) {
            case HorizontalConnectionType.SINGLE -> T_WLR;
            case HorizontalConnectionType.LEFT -> T_WL;
            case HorizontalConnectionType.RIGHT -> T_WR;
            default -> TOP;
        };
    }

    public RenderShape m_7514_(BlockState state) {
        return RenderShape.MODEL;
    }

    @Nullable
    public BlockState m_5573_(BlockPlaceContext pContext) {
        boolean waterlogged = pContext.m_43725_().m_6425_(pContext.m_8083_()).m_76152_() == Fluids.f_76193_;
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)FACING, (Comparable)pContext.m_8125_().m_122424_())).m_61124_((Property)WATERLOGGED, (Comparable)Boolean.valueOf(waterlogged));
    }

    public BlockState m_7417_(BlockState pState, Direction pDirection, BlockState pNeighborState, LevelAccessor pLevel, BlockPos pCurrentPos, BlockPos pNeighborPos) {
        boolean r_side;
        BlockEntity blockentity;
        if (((Boolean)pState.m_61143_((Property)WATERLOGGED)).booleanValue()) {
            pLevel.m_186469_(pCurrentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)pLevel));
        }
        if (pLevel.m_8055_(pCurrentPos.m_7494_()).m_60783_((BlockGetter)pLevel, pCurrentPos, Direction.DOWN) && (blockentity = pLevel.m_7702_(pCurrentPos)) instanceof ShelfBlockEntity) {
            ShelfBlockEntity shelfblockentity = (ShelfBlockEntity)blockentity;
            shelfblockentity.removeAllItems();
        }
        Direction facing = (Direction)pState.m_61143_((Property)FACING);
        BlockState l_state = pLevel.m_8055_(pCurrentPos.m_121945_(facing.m_122427_()));
        BlockState r_state = pLevel.m_8055_(pCurrentPos.m_121945_(facing.m_122428_()));
        boolean l_side = l_state.m_60734_() instanceof ShelfBlock && l_state.m_61143_((Property)FACING) == facing;
        boolean bl = r_side = r_state.m_60734_() instanceof ShelfBlock && r_state.m_61143_((Property)FACING) == facing;
        HorizontalConnectionType type = l_side && r_side ? HorizontalConnectionType.MIDDLE : (r_side ? HorizontalConnectionType.LEFT : (l_side ? HorizontalConnectionType.RIGHT : HorizontalConnectionType.SINGLE));
        return (BlockState)pState.m_61124_(TYPE, (Comparable)((Object)type));
    }

    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)WATERLOGGED) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nullable
    public BlockEntity m_142194_(BlockPos pPos, BlockState pState) {
        return new ShelfBlockEntity(pPos, pState);
    }

    private int getPosition(BlockHitResult hit, BlockPos pos) {
        Vec3 hitVec = hit.m_82450_().m_82492_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        int position = 0;
        if (hitVec.m_7096_() > 0.5) {
            ++position;
        }
        if (hitVec.m_7094_() > 0.5) {
            position += 2;
        }
        return position;
    }

    public BlockState m_6843_(BlockState pState, Rotation pRotation) {
        return (BlockState)pState.m_61124_((Property)FACING, (Comparable)pRotation.m_55954_((Direction)pState.m_61143_((Property)FACING)));
    }

    public BlockState m_6943_(BlockState pState, Mirror pMirror) {
        return pState.m_60717_(pMirror.m_54846_((Direction)pState.m_61143_((Property)FACING)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        pBuilder.m_61104_(new Property[]{FACING, TYPE, WATERLOGGED});
    }

    public boolean m_7357_(BlockState state, BlockGetter level, BlockPos pos, PathComputationType type) {
        return false;
    }
}

