/*
 * Decompiled with CFR 0.152.
 */
package com.github.Pandarix.beautify.common.block;

import com.github.Pandarix.beautify.core.init.SoundInit;
import com.github.Pandarix.beautify.util.Config;
import com.github.Pandarix.beautify.util.KeyBoardHelper;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.HorizontalDirectionalBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public class OakBlinds
extends HorizontalDirectionalBlock {
    private static final VoxelShape OPEN_NORTH = Block.m_49796_((double)0.0, (double)13.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape OPEN_SOUTH = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)3.0);
    private static final VoxelShape OPEN_WEST = Block.m_49796_((double)13.0, (double)13.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape OPEN_EAST = Block.m_49796_((double)0.0, (double)13.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape CLOSED_SOUTH = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)2.0);
    private static final VoxelShape CLOSED_NORTH = Block.m_49796_((double)0.0, (double)0.0, (double)13.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape CLOSED_EAST = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)3.0, (double)16.0, (double)16.0);
    private static final VoxelShape CLOSED_WEST = Block.m_49796_((double)13.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    private static final VoxelShape SHAPE_HIDDEN = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0, (double)0.0);
    public static final BooleanProperty OPEN = BooleanProperty.m_61465_((String)"open");
    public static final BooleanProperty HIDDEN = BooleanProperty.m_61465_((String)"hidden");

    public OakBlinds(BlockBehaviour.Properties p_54120_) {
        super(p_54120_);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)f_54117_, (Comparable)Direction.NORTH)).m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false)));
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)f_54117_, (Comparable)context.m_8125_().m_122424_())).m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> pBuilder) {
        super.m_7926_(pBuilder);
        pBuilder.m_61104_(new Property[]{OPEN, f_54117_, HIDDEN});
    }

    public InteractionResult m_6227_(BlockState pState, Level pLevel, BlockPos pPos, Player pPlayer, InteractionHand pHand, BlockHitResult pResult) {
        if (!pLevel.m_5776_() && pHand == InteractionHand.MAIN_HAND && pPlayer.m_21120_(pHand).m_41619_()) {
            boolean currentlyOpen = (Boolean)pState.m_61143_((Property)OPEN);
            if (((Boolean)Config.OPENS_FROM_ROOT.get()).booleanValue()) {
                int step = 1;
                while (this.sameBlindType(pLevel, pPos.m_6630_(step), pState)) {
                    ++step;
                }
                pPos = pPos.m_6630_(step - 1);
            }
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
            if ((Integer)Config.SEARCHRADIUS.get() > 0) {
                for (int offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.m_6625_(offsetDown), pState); ++offsetDown) {
                    this.switchOpenUpdateHidden(pLevel, pPos.m_6625_(offsetDown), pState, false);
                }
            }
            if ((Integer)Config.SEARCHRADIUS.get() > 0) {
                int offsetDown;
                if (pState.m_61143_((Property)f_54117_) == Direction.NORTH || pState.m_61143_((Property)f_54117_) == Direction.SOUTH) {
                    for (int offsetEast = 1; offsetEast <= (Integer)Config.SEARCHRADIUS.get() / 2 && this.sameBlindType(pLevel, pPos.m_142385_(offsetEast), pState); ++offsetEast) {
                        pLevel.m_7731_(pPos.m_142385_(offsetEast), (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
                        for (offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.m_6625_(offsetDown).m_142385_(offsetEast), pState); ++offsetDown) {
                            this.switchOpenUpdateHidden(pLevel, pPos.m_6625_(offsetDown).m_142385_(offsetEast), pState, false);
                        }
                    }
                    for (int offsetWest = 1; offsetWest <= (Integer)Config.SEARCHRADIUS.get() / 2 && this.sameBlindType(pLevel, pPos.m_142386_(offsetWest), pState); ++offsetWest) {
                        pLevel.m_7731_(pPos.m_142386_(offsetWest), (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
                        for (offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.m_6625_(offsetDown).m_142386_(offsetWest), pState); ++offsetDown) {
                            this.switchOpenUpdateHidden(pLevel, pPos.m_6625_(offsetDown).m_142386_(offsetWest), pState, false);
                        }
                    }
                }
                if (pState.m_61143_((Property)f_54117_) == Direction.EAST || pState.m_61143_((Property)f_54117_) == Direction.WEST) {
                    for (int offsetNorth = 1; offsetNorth <= (Integer)Config.SEARCHRADIUS.get() / 2 && this.sameBlindType(pLevel, pPos.m_142390_(offsetNorth), pState); ++offsetNorth) {
                        pLevel.m_7731_(pPos.m_142390_(offsetNorth), (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
                        for (offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.m_6625_(offsetDown).m_142390_(offsetNorth), pState); ++offsetDown) {
                            this.switchOpenUpdateHidden(pLevel, pPos.m_6625_(offsetDown).m_142390_(offsetNorth), pState, false);
                        }
                    }
                    for (int offsetSouth = 1; offsetSouth <= (Integer)Config.SEARCHRADIUS.get() / 2 && this.sameBlindType(pLevel, pPos.m_142383_(offsetSouth), pState); ++offsetSouth) {
                        pLevel.m_7731_(pPos.m_142383_(offsetSouth), (BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(!currentlyOpen)), 3);
                        for (offsetDown = 1; offsetDown <= (Integer)Config.SEARCHRADIUS.get() && this.sameBlindType(pLevel, pPos.m_6625_(offsetDown).m_142383_(offsetSouth), pState); ++offsetDown) {
                            this.switchOpenUpdateHidden(pLevel, pPos.m_6625_(offsetDown).m_142383_(offsetSouth), pState, false);
                        }
                    }
                }
                pLevel.m_5594_(null, pPos, currentlyOpen ? (SoundEvent)SoundInit.BLINDS_CLOSE.get() : (SoundEvent)SoundInit.BLINDS_OPEN.get(), SoundSource.BLOCKS, 1.0f, 1.0f);
                return InteractionResult.SUCCESS;
            }
        }
        return InteractionResult.SUCCESS;
    }

    private final boolean sameBlindType(Level pLevel, BlockPos pPos, BlockState pState) {
        return pLevel.m_8055_(pPos).m_60734_().getClass() == ((Object)((Object)this)).getClass() && pLevel.m_8055_(pPos).m_61143_((Property)f_54117_) == pState.m_61143_((Property)f_54117_);
    }

    private final void switchOpenUpdateHidden(Level pLevel, BlockPos pPos, BlockState pState, boolean updateOnly) {
        if (updateOnly) {
            pLevel.m_7731_(pPos, (BlockState)pState.m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false)), 3);
            return;
        }
        if (!((Boolean)pState.m_61143_((Property)OPEN)).booleanValue()) {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(true))).m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(false)), 3);
        } else {
            pLevel.m_7731_(pPos, (BlockState)((BlockState)pState.m_61124_((Property)OPEN, (Comparable)Boolean.valueOf(false))).m_61124_((Property)HIDDEN, (Comparable)Boolean.valueOf(true)), 3);
        }
    }

    public boolean onDestroyedByPlayer(BlockState state, Level level, BlockPos pos, Player player, boolean willHarvest, FluidState fluid) {
        if (this.sameBlindType(level, pos.m_7495_(), state)) {
            this.switchOpenUpdateHidden(level, pos.m_7495_(), state, true);
        }
        return super.onDestroyedByPlayer(state, level, pos, player, willHarvest, fluid);
    }

    public VoxelShape m_5940_(BlockState state, BlockGetter getter, BlockPos pos, CollisionContext context) {
        if (((Boolean)state.m_61143_((Property)HIDDEN)).booleanValue()) {
            return SHAPE_HIDDEN;
        }
        if (!((Boolean)state.m_61143_((Property)OPEN)).booleanValue()) {
            return switch ((Direction)state.m_61143_((Property)f_54117_)) {
                case Direction.NORTH -> OPEN_NORTH;
                case Direction.SOUTH -> OPEN_SOUTH;
                case Direction.WEST -> OPEN_WEST;
                case Direction.EAST -> OPEN_EAST;
                default -> OPEN_NORTH;
            };
        }
        return switch ((Direction)state.m_61143_((Property)f_54117_)) {
            case Direction.NORTH -> CLOSED_NORTH;
            case Direction.SOUTH -> CLOSED_SOUTH;
            case Direction.WEST -> CLOSED_WEST;
            case Direction.EAST -> CLOSED_EAST;
            default -> CLOSED_NORTH;
        };
    }

    public void m_5871_(ItemStack stack, BlockGetter getter, List<Component> tooltip, TooltipFlag flag) {
        if (!KeyBoardHelper.isHoldingShift()) {
            tooltip.add((Component)new TextComponent("\u00a77Hold\u00a77 \u00a7e\u00a7oSHIFT\u00a7o\u00a7r \u00a77for more.\u00a77"));
        }
        if (KeyBoardHelper.isHoldingShift()) {
            tooltip.add((Component)new TextComponent("\u00a77Rightclick on Block to open or close blind and adjacent ones.\u00a77"));
            tooltip.add((Component)new TextComponent("\u00a7oNote:\u00a7o \u00a77After closing 1st time, blinds below topmost blind become invisible when open.\u00a77"));
        }
        super.m_5871_(stack, getter, tooltip, flag);
    }
}

