/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.buildpaste.commands;

import com.mistrx.buildpaste.BuildPasteMod;
import com.mistrx.buildpaste.firebase.Firebase;
import com.mistrx.buildpaste.util.Functions;
import com.mistrx.buildpaste.util.Variables;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.HashMap;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.ISuggestionProvider;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextComponentUtils;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;

public class ConstructCommand {
    private static final SuggestionProvider<CommandSource> SUGGESTIONS = (source, builder) -> {
        String[] suggestions = new String[]{Variables.suggestion};
        return ISuggestionProvider.func_197008_a((String[])suggestions, (SuggestionsBuilder)builder);
    };

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"construct").requires(source -> source.func_197034_c(4))).executes(source -> ConstructCommand.constructCommand((CommandSource)source.getSource(), null))).then(Commands.func_197056_a((String)"first argument", (ArgumentType)StringArgumentType.string()).executes(source -> ConstructCommand.constructCommand((CommandSource)source.getSource(), StringArgumentType.getString((CommandContext)source, (String)"first argument")))));
    }

    public static int constructCommand(CommandSource source, String firstarg) {
        IFormattableTextComponent constructbuildcommandcomponent;
        String[] args = new String[]{firstarg, null};
        BuildPasteMod.LOGGER.info("firstarg: " + firstarg);
        if (firstarg != null && firstarg.equals("constructbuild")) {
            String direction = null;
            try {
                direction = Functions.getLookDirection(source.func_197035_h().func_195046_g(1.0f));
                Functions.setPlayerVariables((PlayerEntity)source.func_197035_h());
                if (Functions.sendInvalidUUIDMessage((PlayerEntity)source.func_197035_h()).booleanValue()) {
                    source.func_197030_a((ITextComponent)new TranslationTextComponent("util.doesnt-have-valid-uuid"), true);
                }
            }
            catch (CommandSyntaxException e) {
                BuildPasteMod.LOGGER.info("Error in try catch at constructCommand");
                e.printStackTrace();
            }
            Vector3d pos = new Vector3d(Math.floor(source.func_197036_d().field_72450_a), Math.floor(source.func_197036_d().field_72448_b), Math.floor(source.func_197036_d().field_72449_c));
            Functions.pasteCurrentBuilding(pos, direction, "dontplaceair", false, true);
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.construct.success"), true);
            return 1;
        }
        Variables.playerItems = new HashMap();
        Variables.buildBlocks = new HashMap();
        BuildPasteMod.LOGGER.info("yes");
        try {
            Functions.setPlayerVariables((PlayerEntity)source.func_197035_h());
            ServerPlayerEntity player = source.func_197035_h();
            NonNullList inventory = player.field_71071_by.field_70462_a;
            Integer inventorySize = inventory.size();
            for (int i = 0; i < inventorySize; ++i) {
                String[] itemArray = ((ItemStack)inventory.get(i)).toString().split(" ");
                String itemName = "minecraft:" + itemArray[1];
                Integer itemAmount = Integer.parseInt(itemArray[0]);
                Variables.playerItems.merge(itemName, itemAmount, Integer::sum);
            }
        }
        catch (CommandSyntaxException e) {
            e.printStackTrace();
        }
        BuildPasteMod.LOGGER.info("Construct Command executed");
        String response = Functions.setBuilding(null, "south", args, false);
        if (response.equals("error")) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.paste.error"), true);
            return 0;
        }
        if (response.equals("random-error")) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.paste.random-error"), true);
            return 0;
        }
        if (response.equals("error-404")) {
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.paste.error-404"), true);
            return 0;
        }
        BuildPasteMod.LOGGER.info(response);
        for (int i = 0; i < Firebase.blockIDs.size(); ++i) {
            String block = Functions.getItemFromBlock(Functions.getBlockByIdOrName(Firebase.blockIDs.get(i)));
            Variables.buildBlocks.merge(block, 1, Integer::sum);
        }
        Variables.buildBlocks.remove("minecraft:air");
        Variables.playerItems.remove("minecraft:air");
        Boolean hasAllRequiredMaterials = true;
        Boolean hasAnyRequiredMaterials = false;
        String requiredMaterials = "Needed Materials:\n";
        Object[] buildBlocksKeys = Variables.buildBlocks.keySet().toArray();
        for (int i = 0; i < buildBlocksKeys.length; ++i) {
            String key = buildBlocksKeys[i].toString();
            Integer amount = Variables.buildBlocks.get(key);
            String endText = "";
            TextFormatting color = TextFormatting.WHITE;
            if (Variables.playerItems.containsKey(key)) {
                hasAnyRequiredMaterials = true;
                if (Variables.playerItems.get(key) >= amount) {
                    color = TextFormatting.GREEN;
                } else {
                    endText = " (" + Variables.playerItems.get(key) + "/" + amount.toString() + ")";
                    hasAllRequiredMaterials = false;
                }
            } else {
                hasAllRequiredMaterials = false;
            }
            requiredMaterials = requiredMaterials + color + amount.toString() + " x " + key.replace("minecraft:", "") + endText + "\n";
        }
        String constructBuildCommand = "/construct constructbuild";
        source.func_197030_a((ITextComponent)new StringTextComponent(requiredMaterials), true);
        if (hasAllRequiredMaterials.booleanValue()) {
            constructbuildcommandcomponent = TextComponentUtils.func_240647_a_((ITextComponent)new StringTextComponent("Construct").func_240700_a_(p_211752_2_ -> p_211752_2_.func_240712_a_(TextFormatting.LIGHT_PURPLE).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, constructBuildCommand)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to construct the build"))).func_240714_a_(constructBuildCommand)));
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.construct.all-materials", new Object[]{constructbuildcommandcomponent}), true);
        } else if (hasAnyRequiredMaterials.booleanValue()) {
            constructbuildcommandcomponent = TextComponentUtils.func_240647_a_((ITextComponent)new StringTextComponent("Construct Anyways").func_240700_a_(p_211752_2_ -> p_211752_2_.func_240712_a_(TextFormatting.LIGHT_PURPLE).func_240715_a_(new ClickEvent(ClickEvent.Action.RUN_COMMAND, constructBuildCommand)).func_240716_a_(new HoverEvent(HoverEvent.Action.field_230550_a_, (Object)new StringTextComponent("Click to construct the build"))).func_240714_a_(constructBuildCommand)));
            source.func_197030_a((ITextComponent)new TranslationTextComponent("commands.construct.missing-materials", new Object[]{constructbuildcommandcomponent}), true);
        }
        return 1;
    }
}

