/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.buildpaste.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.Message;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.command.CommandSource;
import net.minecraft.command.Commands;
import net.minecraft.command.arguments.BlockPosArgument;
import net.minecraft.command.arguments.BlockStateArgument;
import net.minecraft.command.arguments.BlockStateInput;
import net.minecraft.command.impl.SetBlockCommand;
import net.minecraft.inventory.IClearable;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.CachedBlockInfo;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MutableBoundingBox;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.server.ServerWorld;

public class SetBlockNoResponseCommand {
    private static final SimpleCommandExceptionType FAILED_EXCEPTION = new SimpleCommandExceptionType((Message)new TranslationTextComponent("commands.setblock.failed"));

    public static void register(CommandDispatcher<CommandSource> dispatcher) {
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)Commands.func_197057_a((String)"_setblocknoresponse").requires(p_198688_0_ -> p_198688_0_.func_197034_c(2))).then(Commands.func_197056_a((String)"pos", (ArgumentType)BlockPosArgument.func_197276_a()).then(((RequiredArgumentBuilder)((RequiredArgumentBuilder)((RequiredArgumentBuilder)Commands.func_197056_a((String)"block", (ArgumentType)BlockStateArgument.func_197239_a()).executes(p_198682_0_ -> SetBlockNoResponseCommand.setBlock((CommandSource)p_198682_0_.getSource(), BlockPosArgument.func_197273_a((CommandContext)p_198682_0_, (String)"pos"), BlockStateArgument.func_197238_a((CommandContext)p_198682_0_, (String)"block"), SetBlockCommand.Mode.REPLACE, null))).then(Commands.func_197057_a((String)"destroy").executes(p_198685_0_ -> SetBlockNoResponseCommand.setBlock((CommandSource)p_198685_0_.getSource(), BlockPosArgument.func_197273_a((CommandContext)p_198685_0_, (String)"pos"), BlockStateArgument.func_197238_a((CommandContext)p_198685_0_, (String)"block"), SetBlockCommand.Mode.DESTROY, null)))).then(Commands.func_197057_a((String)"keep").executes(p_198681_0_ -> SetBlockNoResponseCommand.setBlock((CommandSource)p_198681_0_.getSource(), BlockPosArgument.func_197273_a((CommandContext)p_198681_0_, (String)"pos"), BlockStateArgument.func_197238_a((CommandContext)p_198681_0_, (String)"block"), SetBlockCommand.Mode.REPLACE, p_198687_0_ -> p_198687_0_.func_196960_c().func_175623_d(p_198687_0_.func_177508_d()))))).then(Commands.func_197057_a((String)"replace").executes(p_198686_0_ -> SetBlockNoResponseCommand.setBlock((CommandSource)p_198686_0_.getSource(), BlockPosArgument.func_197273_a((CommandContext)p_198686_0_, (String)"pos"), BlockStateArgument.func_197238_a((CommandContext)p_198686_0_, (String)"block"), SetBlockCommand.Mode.REPLACE, null))))));
    }

    private static int setBlock(CommandSource source, BlockPos pos, BlockStateInput state, SetBlockCommand.Mode mode, @Nullable Predicate<CachedBlockInfo> predicate) throws CommandSyntaxException {
        boolean flag;
        ServerWorld serverworld = source.func_197023_e();
        if (predicate != null && !predicate.test(new CachedBlockInfo((IWorldReader)serverworld, pos, true))) {
            return 0;
        }
        if (mode == SetBlockCommand.Mode.DESTROY) {
            serverworld.func_175655_b(pos, true);
            flag = !state.func_197231_a().func_196958_f() || !serverworld.func_180495_p(pos).func_196958_f();
        } else {
            TileEntity tileentity = serverworld.func_175625_s(pos);
            IClearable.func_213131_a((Object)tileentity);
            flag = true;
        }
        if (flag && !state.func_197230_a(serverworld, pos, 2)) {
            return 0;
        }
        serverworld.func_230547_a_(pos, state.func_197231_a().func_177230_c());
        return 1;
    }

    public static enum Mode {
        REPLACE,
        DESTROY;

    }

    public static interface IFilter {
        @Nullable
        public BlockStateInput filter(MutableBoundingBox var1, BlockPos var2, BlockStateInput var3, ServerWorld var4);
    }
}

