/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.buildpaste.events;

import com.mistrx.buildpaste.BuildPasteMod;
import com.mistrx.buildpaste.commands.BuildPasteHelpCommand;
import com.mistrx.buildpaste.commands.ClearNoResponseCommand;
import com.mistrx.buildpaste.commands.ConstructCommand;
import com.mistrx.buildpaste.commands.CopyUploadedBuildCommand;
import com.mistrx.buildpaste.commands.DisconnectAccountCommand;
import com.mistrx.buildpaste.commands.GameRuleNoResponse;
import com.mistrx.buildpaste.commands.PasteCommand;
import com.mistrx.buildpaste.commands.PositionSelectorCommand;
import com.mistrx.buildpaste.commands.RemovePosCommand;
import com.mistrx.buildpaste.commands.SetBlockNoResponseCommand;
import com.mistrx.buildpaste.commands.SetFirstPositionCommand;
import com.mistrx.buildpaste.commands.SetSecondPositionCommand;
import com.mistrx.buildpaste.commands.TitleNoResponseCommand;
import com.mistrx.buildpaste.commands.UndoPasteCommand;
import com.mistrx.buildpaste.commands.UploadCommand;
import com.mistrx.buildpaste.commands.VerifyCommand;
import com.mistrx.buildpaste.util.Functions;
import com.mistrx.buildpaste.util.RegistryHandler;
import com.mojang.brigadier.CommandDispatcher;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.command.CommandSource;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.math.vector.Vector3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buildpaste", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ModClientEvents {
    public static Vector3d lastHitPosition;
    public static Vector3d pos1;
    public static Vector3d pos2;
    private static Integer tickCount;

    @SubscribeEvent
    public static void registerCommandsEvent(RegisterCommandsEvent event) {
        BuildPasteHelpCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        UploadCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        PasteCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        VerifyCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        DisconnectAccountCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        UndoPasteCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        SetFirstPositionCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        SetSecondPositionCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        RemovePosCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        PositionSelectorCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        ConstructCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        GameRuleNoResponse.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        TitleNoResponseCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        SetBlockNoResponseCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        ClearNoResponseCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        CopyUploadedBuildCommand.register((CommandDispatcher<CommandSource>)event.getDispatcher());
        BuildPasteMod.LOGGER.info("Minecraft Started Event");
        Functions.setItemEqualsBlockHashmap();
    }

    @SubscribeEvent
    public static void onLeftClickWithPositionSelector(PlayerInteractEvent.LeftClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        if (player.func_184614_ca().func_77973_b() == RegistryHandler.POSITION_SELECTOR.get()) {
            Vector3d hitPos = Minecraft.func_71410_x().field_71476_x.func_216347_e();
            pos1 = ModClientEvents.getBlockPos(hitPos, event.getFace());
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("item.buildpaste.position_selecter.pos1", new Object[]{pos1}), player.func_110124_au());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickWithPositionSelector(PlayerInteractEvent.RightClickBlock event) {
        PlayerEntity player = event.getPlayer();
        World world = player.func_130014_f_();
        if (player.func_184614_ca().func_77973_b() == RegistryHandler.POSITION_SELECTOR.get()) {
            Vector3d hitPos = Minecraft.func_71410_x().field_71476_x.func_216347_e();
            pos2 = ModClientEvents.getBlockPos(hitPos, event.getFace());
            if (!world.field_72995_K) {
                player.func_145747_a((ITextComponent)new TranslationTextComponent("item.buildpaste.position_selecter.pos2", new Object[]{pos2}), player.func_110124_au());
            }
            event.setCanceled(true);
        }
    }

    public static Vector3d getBlockPos(Vector3d hitPos, Direction face) {
        Vector3d result = hitPos;
        if (face == Direction.EAST) {
            result = result.func_72441_c(-1.0, 0.0, 0.0);
        } else if (face == Direction.UP) {
            result = result.func_72441_c(0.0, -1.0, 0.0);
        } else if (face == Direction.SOUTH) {
            result = result.func_72441_c(0.0, 0.0, -1.0);
        }
        result = new Vector3d(Math.floor(result.field_72450_a), Math.floor(result.field_72448_b), Math.floor(result.field_72449_c));
        return result;
    }

    @SubscribeEvent
    public static void TickEvent(TickEvent.PlayerTickEvent event) throws IOException {
        PlayerEntity player = event.player;
        World world = player.func_130014_f_();
        if (pos1 != null && pos2 != null && !world.field_72995_K) {
            String direction = Functions.getLookDirection(player.func_195046_g(1.0f));
            String command = "/_titlenoresponse " + player.func_200200_C_().getString() + " actionbar {\"text\":\"Look at the front of your selected build and type /upload\", \"color\": \"green\"}";
            Minecraft.func_71410_x().field_71439_g.func_71165_d(command);
        }
        Integer n = tickCount;
        Integer n2 = tickCount = Integer.valueOf(tickCount + 1);
    }

    static {
        tickCount = 0;
    }
}

