/*
 * Decompiled with CFR 0.152.
 */
package com.mistrx.buildpaste.events;

import com.mistrx.buildpaste.BuildPasteMod;
import com.mistrx.buildpaste.commands.BuildPasteHelpCommand;
import com.mistrx.buildpaste.commands.ConstructCommand;
import com.mistrx.buildpaste.commands.CopyUploadedBuildCommand;
import com.mistrx.buildpaste.commands.DisconnectAccountCommand;
import com.mistrx.buildpaste.commands.PasteCommand;
import com.mistrx.buildpaste.commands.PositionSelectorCommand;
import com.mistrx.buildpaste.commands.RemovePosCommand;
import com.mistrx.buildpaste.commands.SetFirstPositionCommand;
import com.mistrx.buildpaste.commands.SetSecondPositionCommand;
import com.mistrx.buildpaste.commands.UndoPasteCommand;
import com.mistrx.buildpaste.commands.UploadCommand;
import com.mistrx.buildpaste.commands.VerifyCommand;
import com.mistrx.buildpaste.commands._ClearCommand;
import com.mistrx.buildpaste.commands._SetBlockCommand;
import com.mistrx.buildpaste.commands._TitleCommand;
import com.mistrx.buildpaste.util.Functions;
import com.mistrx.buildpaste.util.RegistryHandler;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.math.Vector3d;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.commands.CommandSourceStack;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.event.RegisterCommandsEvent;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;

@Mod.EventBusSubscriber(modid="buildpaste", bus=Mod.EventBusSubscriber.Bus.FORGE, value={Dist.CLIENT})
public class ModClientEvents {
    public static Vector3d lastHitPosition;
    public static Vector3d pos1;
    public static Vector3d pos2;
    private static Integer tickCount;

    @SubscribeEvent
    public static void registerCommandsEvent(RegisterCommandsEvent event) {
        BuildPasteHelpCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        UploadCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PasteCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        VerifyCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        DisconnectAccountCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        UndoPasteCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SetFirstPositionCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        SetSecondPositionCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        RemovePosCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        PositionSelectorCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        ConstructCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        _TitleCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        _SetBlockCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        _ClearCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        CopyUploadedBuildCommand.register((CommandDispatcher<CommandSourceStack>)event.getDispatcher());
        BuildPasteMod.LOGGER.info("Minecraft Started Event");
        Functions.setItemEqualsBlockHashmap();
    }

    @SubscribeEvent
    public static void onLeftClickWithPositionSelector(PlayerInteractEvent.LeftClickBlock event) {
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == RegistryHandler.POSITION_SELECTOR.get()) {
            BlockPos hitPos = event.getPos();
            pos1 = new Vector3d((double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_());
            if (world.f_46443_) {
                BuildPasteMod.LOGGER.info("Client side");
                String posString = "(" + Math.round(hitPos.m_123341_()) + ", " + Math.round(hitPos.m_123342_()) + ", " + Math.round(hitPos.m_123343_()) + ")";
                player.m_6352_((Component)new TranslatableComponent("item.buildpaste.position_selecter.pos1", new Object[]{posString}), player.m_142081_());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void onRightClickWithPositionSelector(PlayerInteractEvent.RightClickBlock event) {
        if (event.getHand() != InteractionHand.MAIN_HAND) {
            return;
        }
        Player player = event.getPlayer();
        Level world = player.m_20193_();
        if (player.m_21120_(InteractionHand.MAIN_HAND).m_41720_() == RegistryHandler.POSITION_SELECTOR.get()) {
            BlockPos hitPos = event.getPos();
            pos2 = new Vector3d((double)hitPos.m_123341_(), (double)hitPos.m_123342_(), (double)hitPos.m_123343_());
            if (world.f_46443_) {
                String posString = "(" + Math.round(hitPos.m_123341_()) + ", " + Math.round(hitPos.m_123342_()) + ", " + Math.round(hitPos.m_123343_()) + ")";
                player.m_6352_((Component)new TranslatableComponent("item.buildpaste.position_selecter.pos2", new Object[]{posString}), player.m_142081_());
            }
            event.setCanceled(true);
        }
    }

    @SubscribeEvent
    public static void TickEvent(TickEvent.PlayerTickEvent event) throws IOException {
        if (tickCount % 20 * 3 == 0 && pos1 != null && pos2 != null) {
            Player player = event.player;
            Level world = player.m_20193_();
            String direction = Functions.getLookDirection(player.m_5675_(1.0f));
            String command = "_titlenoresponse " + player.m_7755_().getString() + " actionbar {\"text\":\"Look at the front of your selected build and type /upload\", \"color\": \"green\"}";
            try {
                Minecraft.m_91087_().m_91092_().m_129892_().m_82094_().execute(command, (Object)Minecraft.m_91087_().m_91092_().m_129893_());
            }
            catch (CommandSyntaxException e) {
                e.printStackTrace();
            }
        }
        Integer n = tickCount;
        tickCount = tickCount + 1;
    }

    static {
        tickCount = 0;
    }
}

