/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.block.EnchantmentBaseBlock;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantmentPacket;
import de.cheaterpaul.enchantmentmachine.tiles.StorageTileEntity;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.AbstractBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.BlockRayTraceResult;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StorageBlock
extends EnchantmentBaseBlock {
    protected static final VoxelShape SHAPE = StorageBlock.makeShape();

    public StorageBlock(AbstractBlock.Properties properties) {
        super(properties);
    }

    @Nullable
    public TileEntity func_196283_a_(@Nonnull IBlockReader worldIn) {
        return ModData.storage_tile.func_200968_a();
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_190948_a(@Nonnull ItemStack stack, @Nullable IBlockReader worldIn, @Nonnull List<ITextComponent> tooltip, @Nonnull ITooltipFlag flagIn) {
        super.func_190948_a(stack, worldIn, tooltip, flagIn);
        CompoundNBT nbt = stack.func_77978_p();
        int count = nbt != null ? nbt.func_74762_e("enchantmentcount") : 0;
        tooltip.add((ITextComponent)new TranslationTextComponent("text.enchantment_block.contained_enchantments", new Object[]{count}));
    }

    public void func_180657_a(@Nonnull World worldIn, @Nonnull PlayerEntity player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable TileEntity te, @Nonnull ItemStack heldStack) {
        ItemStack stack = new ItemStack((IItemProvider)ModData.storage_block, 1);
        if (te instanceof StorageTileEntity) {
            ((StorageTileEntity)te).writeEnchantments(stack.func_190925_c("BlockEntityTag"));
            stack.func_196082_o().func_74768_a("enchantmentcount", ((StorageTileEntity)te).getEnchantmentCount());
        }
        StorageBlock.func_180635_a((World)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    @Nonnull
    public ActionResultType func_225533_a_(@Nonnull BlockState blockState, World world, @Nonnull BlockPos blockPos, @Nonnull PlayerEntity playerEntity, @Nonnull Hand p_225533_5_, @Nonnull BlockRayTraceResult p_225533_6_) {
        TileEntity tile = world.func_175625_s(blockPos);
        if (tile instanceof StorageTileEntity && playerEntity instanceof ServerPlayerEntity) {
            EnchantmentMachineMod.DISPATCHER.sendTo(new EnchantmentPacket(((StorageTileEntity)tile).getEnchantments(), true), (ServerPlayerEntity)playerEntity);
            return ActionResultType.CONSUME;
        }
        return ActionResultType.SUCCESS;
    }

    @Nonnull
    public VoxelShape func_220053_a(@Nonnull BlockState state, @Nonnull IBlockReader worldIn, @Nonnull BlockPos pos, @Nonnull ISelectionContext context) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        return Block.func_208617_a((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    }
}

