/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.client.screen.EnchantmentBaseScreen;
import de.cheaterpaul.enchantmentmachine.client.screen.ScrollableListButton;
import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import de.cheaterpaul.enchantmentmachine.inventory.EnchanterContainer;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantingPacket;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.gui.widget.button.ImageButton;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class EnchanterScreen
extends EnchantmentBaseScreen<EnchanterContainer> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("enchantmentmachine", "textures/gui/container/enchanter.png");
    private final Map<EnchantmentInstance, Pair<EnchantmentInstance, Integer>> enchantments = new HashMap<EnchantmentInstance, Pair<EnchantmentInstance, Integer>>();
    private ScrollableListButton<Pair<EnchantmentInstance, Integer>> list;
    private Map<Enchantment, Integer> itemEnchantments = new HashMap<Enchantment, Integer>();

    public EnchanterScreen(EnchanterContainer container, PlayerInventory playerInventory, ITextComponent name) {
        super(container, playerInventory, name);
        this.field_146999_f = 232;
        this.field_147000_g = 241;
        this.field_238744_r_ = 36;
        this.field_238745_s_ = this.field_147000_g - 94;
        container.setListener(this::refreshActiveEnchantments);
    }

    protected void func_230450_a_(@Nonnull MatrixStack matrixStack, float partialTicks, int x, int y) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        int i = this.field_147003_i;
        int j = this.field_147009_r;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.field_146999_f, this.field_147000_g);
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
        this.func_230459_a_(matrixStack, mouseX, mouseY);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.list = new ScrollableListButton<Pair>(this.field_147003_i + 8, this.field_147009_r + 15, this.field_146999_f - 50, this.field_147000_g - 94 - 17, 21, x$0 -> new EnchantmentItem((Pair<EnchantmentInstance, Integer>)x$0));
        this.func_230480_a_((Widget)this.list);
    }

    public void updateEnchantments(Object2IntMap<EnchantmentInstance> enchantments) {
        this.enchantments.clear();
        enchantments.forEach((instance, integer) -> this.enchantments.put((EnchantmentInstance)instance, (Pair<EnchantmentInstance, Integer>)Pair.of((Object)instance, (Object)integer)));
        this.refreshActiveEnchantments();
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        if (!this.field_147007_t) {
            this.list.func_231045_a_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void refreshActiveEnchantments() {
        ItemStack stack = ((EnchanterContainer)this.field_147002_h).func_75139_a(0).func_75211_c();
        this.itemEnchantments = EnchantmentHelper.func_82781_a((ItemStack)stack);
        if (stack.func_190926_b()) {
            this.list.setItems(this.enchantments.values());
        } else {
            this.list.setItems(this.enchantments.values().stream().filter(pair -> stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() == Items.field_151134_bR || ((EnchantmentInstance)pair.getKey()).getEnchantment().func_92089_a(stack)).collect(Collectors.toList()));
        }
    }

    private void apply(EnchantmentInstance instance) {
        if (((EnchanterContainer)this.field_147002_h).func_75139_a(0).func_75216_d() && (((Boolean)ModConfig.SERVER.allowMixtureEnchantments.get()).booleanValue() || EnchantmentHelper.func_201840_a(this.itemEnchantments.keySet(), (Enchantment)instance.getEnchantment()) || this.hasEqualEnchantments(this.itemEnchantments, instance))) {
            EnchantmentMachineMod.DISPATCHER.sendToServer(new EnchantingPacket(Collections.singletonList(instance)));
            Pair<EnchantmentInstance, Integer> value = this.enchantments.get(instance);
            if ((Integer)value.getValue() > 1) {
                this.enchantments.put(instance, (Pair<EnchantmentInstance, Integer>)Pair.of((Object)instance, (Object)((Integer)value.getValue() - 1)));
            } else {
                this.enchantments.remove(instance);
            }
        }
        this.refreshActiveEnchantments();
    }

    private boolean hasEqualEnchantments(Map<Enchantment, Integer> itemEnchantments, EnchantmentInstance enchantment) {
        for (Map.Entry<Enchantment, Integer> entry : itemEnchantments.entrySet()) {
            if (entry.getKey() != enchantment.getEnchantment() || Utils.getEnchantmentMaxLevel(entry.getKey()) == entry.getValue() || entry.getValue() > enchantment.getLevel()) continue;
            return true;
        }
        return false;
    }

    private class EnchantmentItem
    extends ScrollableListButton.ListItem<Pair<EnchantmentInstance, Integer>> {
        private final ItemStack bookStack;
        private final ITextComponent name;
        private final Button button;
        private final int requiredLevels;

        public EnchantmentItem(Pair<EnchantmentInstance, Integer> item) {
            super(item);
            this.bookStack = new ItemStack((IItemProvider)Items.field_151134_bR, ((Integer)item.getRight()).intValue());
            EnchantmentHelper.func_82782_a(Collections.singletonMap(((EnchantmentInstance)item.getKey()).getEnchantment(), ((EnchantmentInstance)item.getKey()).getLevel()), (ItemStack)this.bookStack);
            this.name = ((EnchantmentInstance)item.getKey()).getEnchantment().func_200305_d(((EnchantmentInstance)item.getKey()).getLevel());
            Style style = this.name.func_150256_b();
            if (style.func_240711_a_() != null && style.func_240711_a_().func_240742_a_() == TextFormatting.GRAY.func_211163_e().intValue()) {
                ((IFormattableTextComponent)this.name).func_240699_a_(TextFormatting.WHITE);
            }
            this.button = new ImageButton(0, 0, 11, 17, 1, 208, 18, new ResourceLocation("textures/gui/recipe_book.png"), 256, 256, button -> EnchanterScreen.this.apply((EnchantmentInstance)item.getKey()), new Button.ITooltip(){

                public void onTooltip(@Nonnull Button button, @Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
                    if (mouseX > button.field_230690_l_ && mouseX < button.field_230690_l_ + button.func_230998_h_() && mouseY > button.field_230691_m_ && mouseY < button.field_230691_m_ + button.func_238483_d_()) {
                        IFormattableTextComponent text = EnchantmentItem.this.isCompatible() ? (EnchantmentItem.this.hasSufficientLevels() ? new TranslationTextComponent("text.enchantmentmachine.enchant_for_level", new Object[]{EnchantmentItem.this.requiredLevels}).func_240699_a_(TextFormatting.GREEN) : new TranslationTextComponent("text.enchantmentmachine.require_level", new Object[]{EnchantmentItem.this.requiredLevels}).func_240699_a_(TextFormatting.YELLOW)) : new TranslationTextComponent("text.enchantmentmachine.unavailable").func_240699_a_(TextFormatting.RED);
                        EnchanterScreen.this.func_238652_a_(matrixStack, (ITextComponent)text, mouseX, mouseY);
                    }
                }
            }, StringTextComponent.field_240750_d_);
            this.requiredLevels = this.calculateRequiredLevels();
        }

        @Override
        public boolean onClick(double mouseX, double mouseY) {
            if (!this.button.field_230694_p_) {
                return false;
            }
            if (mouseX > (double)this.button.field_230690_l_ && mouseX < (double)(this.button.field_230690_l_ + this.button.func_230998_h_()) && mouseY > (double)this.button.field_230691_m_ && mouseY < (double)(this.button.field_230691_m_ + this.button.func_238483_d_())) {
                if (this.isCompatible() && this.hasSufficientLevels()) {
                    this.button.func_230982_a_(mouseX, mouseY);
                }
                return true;
            }
            return false;
        }

        private boolean isCompatible() {
            EnchantmentInstance s = (EnchantmentInstance)((Pair)this.item).getKey();
            for (Map.Entry entry : EnchanterScreen.this.itemEnchantments.entrySet()) {
                Enchantment enchantment = (Enchantment)entry.getKey();
                if (enchantment != s.getEnchantment()) continue;
                int newLevel = Math.min(Utils.getEnchantmentMaxLevel(enchantment), s.getLevel() == ((Integer)entry.getValue()).intValue() ? s.getLevel() + 1 : Math.max(s.getLevel(), (Integer)entry.getValue()));
                s = new EnchantmentInstance(enchantment, newLevel);
            }
            return s.canEnchant() && ((Boolean)ModConfig.SERVER.allowMixtureEnchantments.get() != false || EnchantmentHelper.func_201840_a(EnchanterScreen.this.itemEnchantments.keySet(), (Enchantment)((EnchantmentInstance)((Pair)this.item).getKey()).getEnchantment()) || EnchanterScreen.this.hasEqualEnchantments(EnchanterScreen.this.itemEnchantments, (EnchantmentInstance)((Pair)this.item).getKey()));
        }

        @Override
        public void render(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float partialTicks, float zLevel) {
            super.render(matrixStack, x, y, listWidth, listHeight, itemHeight, yOffset, mouseX, mouseY, partialTicks, zLevel);
            EnchanterScreen.this.field_230707_j_.func_239390_c_(this.bookStack, x + 5, y + 2 + yOffset);
            EnchanterScreen.this.field_230712_o_.func_243246_a(matrixStack, this.name, (float)(x + 25), (float)(y + yOffset + 5), -1);
            String count = String.valueOf(this.bookStack.func_190916_E());
            EnchanterScreen.this.field_230712_o_.func_238405_a_(matrixStack, count, (float)(x + listWidth - 20), (float)(y + yOffset + 5), 0xFFFFFF);
            this.button.field_230690_l_ = x + listWidth - 12;
            this.button.field_230691_m_ = y + yOffset + 2;
            this.button.field_230694_p_ = ((EnchanterContainer)EnchanterScreen.this.field_147002_h).func_75139_a(0).func_75216_d();
            if (this.isCompatible()) {
                if (this.hasSufficientLevels()) {
                    RenderSystem.color4f((float)0.2f, (float)1.0f, (float)0.4f, (float)1.0f);
                } else {
                    RenderSystem.color4f((float)0.5f, (float)0.4f, (float)0.2f, (float)1.0f);
                }
            } else {
                RenderSystem.color4f((float)1.0f, (float)0.2f, (float)0.4f, (float)1.0f);
            }
            RenderSystem.pushMatrix();
            this.button.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
            RenderSystem.popMatrix();
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void renderToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float zLevel) {
            if (mouseX > x && mouseX < x + listWidth - 12 && mouseY > y && mouseY < y + itemHeight) {
                EnchanterScreen.this.func_230457_a_(matrixStack, this.bookStack, mouseX, mouseY);
            }
            if (this.button.field_230694_p_) {
                this.button.func_230443_a_(matrixStack, mouseX, mouseY);
            }
        }

        private int calculateRequiredLevels() {
            Pair<EnchantmentInstance, Integer> result = Utils.tryApplyEnchantment((EnchantmentInstance)((Pair)this.item).getKey(), EnchanterScreen.this.itemEnchantments, true);
            return result == null ? -1 : (Integer)result.getRight();
        }

        private boolean hasSufficientLevels() {
            return ((EnchanterScreen)EnchanterScreen.this).field_213127_e.field_70458_d.field_71068_ca >= this.requiredLevels || ((EnchanterScreen)EnchanterScreen.this).field_213127_e.field_70458_d.field_71075_bZ.field_75098_d;
        }
    }
}

