/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.fml.client.gui.widget.ExtendedButton;

public class ScrollableListButton<T>
extends ExtendedButton {
    private static final ResourceLocation MISC = new ResourceLocation("enchantmentmachine", "textures/gui/misc.png");
    private final ItemCreator<T> itemSupplier;
    private final int itemHeight;
    private final int scrollerWidth = 9;
    private final List<ListItem<T>> listItems = new ArrayList<ListItem<T>>();
    private int scrolled;
    private double scrolledD;
    private boolean scrollerClicked;
    private boolean canScroll = true;

    public ScrollableListButton(int xPos, int yPos, int width, int height, int itemHeight) {
        this(xPos, yPos, width, height, itemHeight, ListItem::new);
    }

    public ScrollableListButton(int xPos, int yPos, int width, int height, int itemHeight, ItemCreator<T> itemSupplier) {
        super(xPos, yPos, width, height, (ITextComponent)new StringTextComponent(""), button -> {});
        this.itemHeight = itemHeight;
        this.itemSupplier = itemSupplier;
    }

    public void setItems(Collection<T> elements) {
        this.listItems.clear();
        elements.forEach(item -> this.listItems.add(this.itemSupplier.apply(item)));
        this.setScrolled(MathHelper.func_76125_a((int)this.scrolled, (int)0, (int)Math.max(0, this.listItems.size() * this.itemHeight - this.field_230689_k_)));
        this.canScroll = this.listItems.size() * this.itemHeight > this.field_230689_k_;
    }

    public void addItem(T element) {
        this.listItems.add(this.itemSupplier.apply(element));
    }

    public void removeItem(T element) {
        this.listItems.removeIf(item -> item.item == element);
        if (this.scrolled > this.listItems.size() * this.itemHeight - this.field_230689_k_) {
            this.setScrolled(this.listItems.size() * this.itemHeight - this.field_230689_k_);
        }
    }

    public void setScrolled(int scrolled) {
        this.scrolled = scrolled;
        this.scrolledD = this.scrolled;
    }

    public int getScrolled() {
        return this.scrolled;
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.pushMatrix();
        RenderSystem.enableDepthTest();
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ScrollableListButton.func_238467_a_((MatrixStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.depthFunc((int)518);
        matrixStack.func_227861_a_((double)this.field_230690_l_, (double)this.field_230691_m_, 0.0);
        ScrollableListButton.func_238467_a_((MatrixStack)matrixStack, (int)this.field_230688_j_, (int)this.field_230689_k_, (int)0, (int)0, (int)-16711680);
        matrixStack.func_227861_a_((double)(-this.field_230690_l_), (double)(-this.field_230691_m_), 0.0);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        this.renderItems(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.enableDepthTest();
        RenderSystem.depthFunc((int)518);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-950.0f);
        RenderSystem.colorMask((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ScrollableListButton.func_238467_a_((MatrixStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        RenderSystem.translatef((float)0.0f, (float)0.0f, (float)950.0f);
        RenderSystem.depthFunc((int)515);
        RenderSystem.disableDepthTest();
        RenderSystem.popMatrix();
        this.func_230443_a_(matrixStack, mouseX, mouseY);
    }

    private void renderBackground(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawContinuousTexturedBox((MatrixStack)matrixStack, (ResourceLocation)new ResourceLocation("textures/gui/widgets.png"), (int)this.field_230690_l_, (int)this.field_230691_m_, (int)0, (int)46, (int)(this.field_230688_j_ - this.scrollerWidth + 1), (int)this.field_230689_k_, (int)200, (int)20, (int)3, (int)3, (int)3, (int)3, (float)this.func_230927_p_());
    }

    private void renderItems(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int itemHeight = this.itemHeight - 1;
        for (int i = 0; i < this.listItems.size(); ++i) {
            int y = i * itemHeight - this.scrolled;
            ListItem<T> item = this.listItems.get(i);
            item.render(matrixStack, this.field_230690_l_, this.field_230691_m_ + 1, this.field_230688_j_ - 9, this.field_230689_k_, this.itemHeight, y, mouseX, mouseY, partialTicks, this.func_230927_p_());
        }
        this.renderScrollBar(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderScrollBar(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        GuiUtils.drawContinuousTexturedBox((MatrixStack)matrixStack, (ResourceLocation)MISC, (int)(this.field_230690_l_ + this.field_230688_j_ - this.scrollerWidth), (int)this.field_230691_m_, (int)0, (int)0, (int)9, (int)this.field_230689_k_, (int)9, (int)200, (int)2, (float)this.func_230927_p_());
        this.renderScroller(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderScroller(MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int scrollerHeight = 27;
        int scrollHeight = this.field_230689_k_ - 2 - scrollerHeight;
        float perc = (float)this.scrolled / (float)(this.listItems.size() * this.itemHeight - this.field_230689_k_);
        int yOffset = (int)((float)scrollHeight * perc);
        Minecraft.func_71410_x().field_71446_o.func_110577_a(MISC);
        this.func_238474_b_(matrixStack, this.field_230690_l_ + this.field_230688_j_ - this.scrollerWidth + 1, this.field_230691_m_ + yOffset + 1, this.canScroll ? 9 : 16, 0, 7, 27);
    }

    public boolean func_231043_a_(double mouseX, double mouseY, double delta) {
        if (this.canScroll) {
            this.scrolled = MathHelper.func_76125_a((int)(this.scrolled + 4 * (int)(-delta)), (int)0, (int)(this.listItems.size() * this.itemHeight - this.field_230689_k_));
            this.scrolledD = this.scrolled;
            return true;
        }
        return false;
    }

    public boolean func_231045_a_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.canScroll && this.scrollerClicked) {
            double perc = dragY / (double)(this.field_230689_k_ - 27);
            double s = (double)(this.listItems.size() * this.itemHeight - this.field_230689_k_) * perc;
            this.scrolledD += s;
            this.scrolled = (int)this.scrolledD;
            this.scrolled = MathHelper.func_76125_a((int)this.scrolled, (int)0, (int)(this.listItems.size() * this.itemHeight - this.field_230689_k_));
            return true;
        }
        return false;
    }

    public boolean func_231044_a_(double mouseX, double mouseY, int button) {
        this.scrolledD = this.scrolled;
        if (mouseX > (double)this.field_230690_l_ && mouseX < (double)(this.field_230690_l_ + this.field_230688_j_) && mouseY > (double)this.field_230691_m_ && mouseY < (double)(this.field_230691_m_ + this.field_230689_k_)) {
            if (mouseX > (double)(this.field_230690_l_ + this.field_230688_j_ - this.scrollerWidth)) {
                this.scrollerClicked = true;
            } else {
                int itemHeight = this.itemHeight - 1;
                for (int i = 0; i < this.listItems.size(); ++i) {
                    int y = i * itemHeight - this.scrolled;
                    if (y < -itemHeight) continue;
                    ListItem<T> item = this.listItems.get(i);
                    if (!(mouseX > (double)this.field_230690_l_) || !(mouseX < (double)(this.field_230690_l_ + this.field_230688_j_ - this.scrollerWidth)) || !(mouseY > (double)(this.field_230691_m_ + y)) || !(mouseY < (double)(this.field_230691_m_ + y + this.itemHeight)) || !item.onClick(mouseX, mouseY)) continue;
                    return true;
                }
            }
        }
        return super.func_231044_a_(mouseX, mouseY, button);
    }

    public void func_230443_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY) {
        if (mouseX > this.field_230690_l_ && mouseX < this.field_230690_l_ + this.field_230688_j_ && mouseY > this.field_230691_m_ && mouseY < this.field_230691_m_ + this.field_230689_k_) {
            int itemHeight = this.itemHeight - 1;
            for (int i = 0; i < this.listItems.size(); ++i) {
                int y = i * itemHeight - this.scrolled;
                if (y < -itemHeight) continue;
                ListItem<T> item = this.listItems.get(i);
                item.preRenderToolTip(matrixStack, this.field_230690_l_, this.field_230691_m_ + y, this.field_230688_j_ - 9, this.field_230689_k_, this.itemHeight, y, mouseX, mouseY, this.func_230927_p_());
            }
        }
    }

    public boolean func_231048_c_(double mouseX, double mouseY, int button) {
        this.scrollerClicked = false;
        return super.func_231048_c_(mouseX, mouseY, button);
    }

    public static class ListItem<T> {
        private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
        protected final T item;

        public ListItem(T item) {
            this.item = item;
        }

        public void render(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float partialTicks, float zLevel) {
            RenderSystem.enableDepthTest();
            GuiUtils.drawContinuousTexturedBox((MatrixStack)matrixStack, (ResourceLocation)WIDGETS, (int)x, (int)(y + yOffset), (int)0, (int)66, (int)(listWidth + 1), (int)itemHeight, (int)200, (int)20, (int)3, (int)3, (int)3, (int)3, (float)zLevel);
            RenderSystem.disableDepthTest();
        }

        public void preRenderToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float zLevel) {
            int ySize = MathHelper.func_76125_a((int)(listHeight - yOffset), (int)0, (int)itemHeight);
            if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + ySize) {
                this.renderToolTip(matrixStack, x, y, listWidth, listHeight, itemHeight, yOffset, mouseX, mouseY, zLevel);
            }
        }

        public void renderToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float zLevel) {
        }

        public boolean onClick(double mouseX, double mouseY) {
            return false;
        }
    }

    @FunctionalInterface
    public static interface ItemCreator<T> {
        public ListItem<T> apply(T var1);
    }
}

