/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.client.screen;

import com.mojang.blaze3d.matrix.MatrixStack;
import de.cheaterpaul.enchantmentmachine.client.screen.ScrollableListButton;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.text.IFormattableTextComponent;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.Style;
import net.minecraft.util.text.TextFormatting;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class StorageScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("enchantmentmachine", "textures/gui/container/enchantment.png");
    private final int xSize = 197;
    private final int ySize = 222;
    private Object2IntMap<EnchantmentInstance> enchantments = new Object2IntArrayMap();
    private ScrollableListButton<Pair<EnchantmentInstance, Integer>> list;
    private int guiLeft;
    private int guiTop;

    public StorageScreen() {
        super((ITextComponent)new StringTextComponent("Enchantments"));
    }

    public void func_231152_a_(@Nonnull Minecraft minecraft, int p_231152_2_, int p_231152_3_) {
        int scrolled = this.list.getScrolled();
        super.func_231152_a_(minecraft, p_231152_2_, p_231152_3_);
        this.updateEnchantments(this.enchantments);
        this.list.setScrolled(scrolled);
    }

    protected void func_231160_c_() {
        super.func_231160_c_();
        this.guiLeft = (this.field_230708_k_ - this.xSize) / 2;
        this.guiTop = (this.field_230709_l_ - this.ySize) / 2;
        this.list = new ScrollableListButton<Pair>(this.guiLeft + 10, this.guiTop + 10, this.xSize - 20, this.ySize - 20, 21, x$0 -> new EnchantmentItem((Pair<EnchantmentInstance, Integer>)x$0));
        this.func_230480_a_((Widget)this.list);
    }

    public boolean func_231177_au__() {
        return false;
    }

    public void func_230430_a_(@Nonnull MatrixStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.func_230446_a_(matrixStack);
        this.field_230706_i_.func_110434_K().func_110577_a(BACKGROUND);
        int i = this.guiLeft;
        int j = this.guiTop;
        this.func_238474_b_(matrixStack, i, j, 0, 0, this.xSize, this.ySize);
        super.func_230430_a_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void updateEnchantments(Object2IntMap<EnchantmentInstance> enchantments) {
        this.enchantments = enchantments;
        this.list.setItems(enchantments.object2IntEntrySet().stream().map(s -> Pair.of((Object)s.getKey(), (Object)s.getIntValue())).collect(Collectors.toSet()));
    }

    private class EnchantmentItem
    extends ScrollableListButton.ListItem<Pair<EnchantmentInstance, Integer>> {
        private final ItemStack bookStack;
        private final ITextComponent name;

        public EnchantmentItem(Pair<EnchantmentInstance, Integer> item) {
            super(item);
            this.bookStack = new ItemStack((IItemProvider)Items.field_151134_bR, ((Integer)item.getRight()).intValue());
            EnchantmentHelper.func_82782_a(Collections.singletonMap(((EnchantmentInstance)item.getKey()).getEnchantment(), ((EnchantmentInstance)item.getKey()).getLevel()), (ItemStack)this.bookStack);
            this.name = ((EnchantmentInstance)item.getKey()).getEnchantment().func_200305_d(((EnchantmentInstance)item.getKey()).getLevel());
            Style style = this.name.func_150256_b();
            if (style.func_240711_a_() == null || style.func_240711_a_().func_240742_a_() == TextFormatting.GRAY.func_211163_e().intValue()) {
                ((IFormattableTextComponent)this.name).func_240703_c_(style.func_240712_a_(TextFormatting.WHITE));
            }
        }

        @Override
        public void render(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float partialTicks, float zLevel) {
            super.render(matrixStack, x, y, listWidth, listHeight, itemHeight, yOffset, mouseX, mouseY, partialTicks, zLevel);
            StorageScreen.this.field_230707_j_.func_239390_c_(this.bookStack, x + 5, y + 2 + yOffset);
            StorageScreen.this.field_230712_o_.func_243246_a(matrixStack, this.name, (float)(x + 25), (float)(y + yOffset + 5), -1);
            String count = String.valueOf(this.bookStack.func_190916_E());
            StorageScreen.this.field_230712_o_.func_238405_a_(matrixStack, count, (float)(x + listWidth - 10), (float)(y + yOffset + 5), 0xFFFFFF);
        }

        @Override
        public void renderToolTip(MatrixStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float zLevel) {
            if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + 222) {
                StorageScreen.this.func_230457_a_(matrixStack, this.bookStack, mouseX, mouseY);
            }
        }
    }
}

