/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import net.minecraft.advancements.ICriterionInstance;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.IDataProvider;
import net.minecraft.data.IFinishedRecipe;
import net.minecraft.data.LootTableProvider;
import net.minecraft.data.RecipeProvider;
import net.minecraft.data.ShapedRecipeBuilder;
import net.minecraft.data.loot.BlockLootTables;
import net.minecraft.item.Items;
import net.minecraft.loot.LootParameterSet;
import net.minecraft.loot.LootParameterSets;
import net.minecraft.loot.LootTable;
import net.minecraft.loot.LootTableManager;
import net.minecraft.loot.ValidationTracker;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.fml.event.lifecycle.GatherDataEvent;

public class ModDataGenerator {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeClient()) {
            generator.func_200390_a((IDataProvider)new BlockStateGenerator(generator, event.getExistingFileHelper()));
            generator.func_200390_a((IDataProvider)new ItemModelGenerator(generator, event.getExistingFileHelper()));
        }
        generator.func_200390_a((IDataProvider)new ModLootTableProvider(generator));
        generator.func_200390_a((IDataProvider)new RecipeGenerator(generator));
    }

    private static class ModLootTableProvider
    extends LootTableProvider {
        public ModLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @Nonnull
        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootParameterSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(() -> new Tables(), (Object)LootParameterSets.field_216267_h));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationTracker validationtracker) {
            map.forEach((resourceLocation, lootTable) -> LootTableManager.func_227508_a_((ValidationTracker)validationtracker, (ResourceLocation)resourceLocation, (LootTable)lootTable));
        }

        private static class Tables
        extends BlockLootTables {
            private Tables() {
            }

            protected void addTables() {
                this.func_218492_c((Block)ModData.disenchanter_block);
                this.func_218492_c((Block)ModData.enchanter_block);
                this.func_218492_c((Block)ModData.storage_block);
            }

            @Nonnull
            protected Iterable<Block> getKnownBlocks() {
                return Lists.newArrayList((Object[])new Block[]{ModData.disenchanter_block, ModData.enchanter_block, ModData.storage_block});
            }
        }
    }

    public static class RecipeGenerator
    extends RecipeProvider {
        public RecipeGenerator(DataGenerator generatorIn) {
            super(generatorIn);
        }

        protected void func_200404_a(@Nonnull Consumer<IFinishedRecipe> consumer) {
            ShapedRecipeBuilder.func_200470_a((IItemProvider)ModData.storage_block).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151122_aG).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235399_ni_).func_200462_a(Character.valueOf('D'), (IItemProvider)Items.field_151045_i).func_200472_a("BBB").func_200472_a("D#D").func_200472_a("###").func_200465_a("has_obsidian", (ICriterionInstance)RecipeGenerator.func_200403_a((IItemProvider)Blocks.field_235399_ni_)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)ModData.disenchanter_block).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151122_aG).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235399_ni_).func_200462_a(Character.valueOf('D'), (IItemProvider)Items.field_151056_x).func_200472_a(" B ").func_200472_a("D#D").func_200472_a("###").func_200465_a("has_obsidian", (ICriterionInstance)RecipeGenerator.func_200403_a((IItemProvider)Blocks.field_235399_ni_)).func_200464_a(consumer);
            ShapedRecipeBuilder.func_200470_a((IItemProvider)ModData.enchanter_block).func_200462_a(Character.valueOf('B'), (IItemProvider)Items.field_151122_aG).func_200462_a(Character.valueOf('#'), (IItemProvider)Blocks.field_235399_ni_).func_200462_a(Character.valueOf('D'), (IItemProvider)Items.field_151045_i).func_200472_a(" B ").func_200472_a("D#D").func_200472_a("###").func_200465_a("has_obsidian", (ICriterionInstance)RecipeGenerator.func_200403_a((IItemProvider)Blocks.field_235399_ni_)).func_200464_a(consumer);
        }
    }

    public static class BlockStateGenerator
    extends BlockStateProvider {
        public BlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "enchantmentmachine", exFileHelper);
        }

        protected void registerStatesAndModels() {
            ModelFile.ExistingModelFile enchanter = new ModelFile.ExistingModelFile(this.blockTexture((Block)ModData.enchanter_block), this.models().existingFileHelper);
            ModelBuilder enchantment_block = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModData.storage_block.getRegistryName().toString(), "block/enchanting_table")).texture("particle", new ResourceLocation("enchantmentmachine", "block/enchanting_table_bottom"))).texture("top", new ResourceLocation("enchantmentmachine", "block/enchanting_table_top"))).texture("side", new ResourceLocation("enchantmentmachine", "block/enchanting_table_side"))).texture("bottom", new ResourceLocation("enchantmentmachine", "block/enchanting_table_bottom"));
            ModelFile.ExistingModelFile disenchanter = new ModelFile.ExistingModelFile(this.blockTexture((Block)ModData.disenchanter_block), this.models().existingFileHelper);
            this.simpleBlock((Block)ModData.enchanter_block, (ModelFile)enchanter);
            this.simpleBlock((Block)ModData.disenchanter_block, (ModelFile)disenchanter);
            this.simpleBlock((Block)ModData.storage_block, (ModelFile)enchantment_block);
        }
    }

    public static class ItemModelGenerator
    extends ItemModelProvider {
        public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "enchantmentmachine", existingFileHelper);
        }

        protected void registerModels() {
            ((ItemModelBuilder)this.getBuilder(ModData.enchanter_block.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.enchanter_block.getRegistryName().func_110623_a()));
            ((ItemModelBuilder)this.getBuilder(ModData.disenchanter_block.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.disenchanter_block.getRegistryName().func_110623_a()));
            ((ItemModelBuilder)this.getBuilder(ModData.storage_block.getRegistryName().func_110623_a())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.storage_block.getRegistryName().func_110623_a()));
        }
    }
}

