/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.inventory;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.inventory.EnchantmentBaseContainer;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantmentPacket;
import de.cheaterpaul.enchantmentmachine.tiles.EnchanterTileEntity;
import de.cheaterpaul.enchantmentmachine.tiles.StorageTileEntity;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Consumer;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.Inventory;
import net.minecraft.inventory.container.Slot;
import net.minecraft.item.ItemStack;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.world.World;

public class EnchanterContainer
extends EnchantmentBaseContainer
implements StorageTileEntity.IEnchantmentListener {
    private final IWorldPosCallable worldPosCallable;
    private final PlayerEntity player;
    private ISlotListener listener;
    private final IInventory inventory;

    public EnchanterContainer(int id, PlayerInventory playerInventory) {
        this(id, (IInventory)new Inventory(1), playerInventory, IWorldPosCallable.field_221489_a);
    }

    public EnchanterContainer(int id, IInventory inventory, PlayerInventory playerInventory, IWorldPosCallable worldPosCallable) {
        super(ModData.enchanter_container, id, 1);
        this.inventory = inventory;
        this.func_75146_a(new Slot(inventory, 0, 203, 19){

            public int func_75219_a() {
                return 1;
            }

            public void func_75218_e() {
                super.func_75218_e();
                if (EnchanterContainer.this.listener != null) {
                    EnchanterContainer.this.listener.slotChanged();
                }
            }
        });
        this.addPlayerSlots(playerInventory, 36, 159);
        this.player = playerInventory.field_70458_d;
        this.worldPosCallable = worldPosCallable;
        this.contactEnchantmentTileEntity(t -> t.registerListener(this));
    }

    public void func_75134_a(PlayerEntity playerIn) {
        super.func_75134_a(playerIn);
        this.contactEnchantmentTileEntity(t -> t.removeListener(this));
        this.worldPosCallable.func_221486_a((world, pos) -> this.func_193327_a(playerIn, (World)world, this.inventory));
    }

    @Override
    public void onEnchantmentsChanged(Object2IntMap<EnchantmentInstance> updatedList) {
        if (this.player instanceof ServerPlayerEntity) {
            EnchantmentPacket p = new EnchantmentPacket(updatedList, false);
            EnchantmentMachineMod.DISPATCHER.sendTo(p, (ServerPlayerEntity)this.player);
        }
    }

    public void setListener(ISlotListener listener) {
        this.listener = listener;
    }

    public IWorldPosCallable getWorldPosCallable() {
        return this.worldPosCallable;
    }

    @Override
    public ItemStack func_82846_b(PlayerEntity playerEntity, int index) {
        return super.func_82846_b(playerEntity, index);
    }

    private void contactEnchantmentTileEntity(Consumer<StorageTileEntity> consumer) {
        this.worldPosCallable.func_221486_a((w, p) -> {
            TileEntity t = w.func_175625_s(p);
            if (t instanceof EnchanterTileEntity) {
                ((EnchanterTileEntity)t).getConnectedEnchantmentTE().ifPresent(consumer);
            }
        });
    }

    @FunctionalInterface
    public static interface ISlotListener {
        public void slotChanged();
    }
}

