/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.network.message;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.network.IMessage;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantingPacket
implements IMessage {
    private final List<EnchantmentInstance> enchantments;

    public EnchantingPacket(List<EnchantmentInstance> enchantments) {
        this.enchantments = enchantments;
    }

    public static void encode(EnchantingPacket msg, PacketBuffer buf) {
        buf.func_150787_b(msg.enchantments.size());
        for (EnchantmentInstance enchantment : msg.enchantments) {
            buf.func_192572_a(enchantment.getEnchantment().getRegistryName());
            buf.func_150787_b(enchantment.getLevel());
        }
    }

    public static EnchantingPacket decode(PacketBuffer buf) {
        ArrayList<EnchantmentInstance> enchantments = new ArrayList<EnchantmentInstance>();
        int enchantmentCount = buf.func_150792_a();
        for (int i = 0; i < enchantmentCount; ++i) {
            ResourceLocation enchantment = buf.func_192575_l();
            int level = buf.func_150792_a();
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(enchantment)) continue;
            enchantments.add(new EnchantmentInstance((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment), level));
        }
        return new EnchantingPacket(enchantments);
    }

    public static void handle(EnchantingPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> EnchantmentMachineMod.PROXY.handleEnchantingPacket(msg, (PlayerEntity)((NetworkEvent.Context)contextSupplier.get()).getSender()));
        ctx.setPacketHandled(true);
    }

    public List<EnchantmentInstance> getEnchantments() {
        return this.enchantments;
    }
}

