/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.network.message;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.network.IMessage;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public class EnchantmentPacket
implements IMessage {
    private final Object2IntMap<EnchantmentInstance> enchantments;
    private final boolean shouldOpenEnchantmentListScreen;

    public EnchantmentPacket(Object2IntMap<EnchantmentInstance> enchantments, boolean shouldOpenEnchantmentListScreen) {
        this.enchantments = enchantments;
        this.shouldOpenEnchantmentListScreen = shouldOpenEnchantmentListScreen;
    }

    public Object2IntMap<EnchantmentInstance> getEnchantments() {
        return this.enchantments;
    }

    public boolean shouldOpenEnchantmentScreen() {
        return this.shouldOpenEnchantmentListScreen;
    }

    public static void encode(EnchantmentPacket msg, PacketBuffer buf) {
        buf.writeBoolean(msg.shouldOpenEnchantmentListScreen);
        buf.func_150787_b(msg.enchantments.size());
        msg.enchantments.forEach((inst, count) -> {
            buf.func_192572_a(inst.getEnchantment().getRegistryName());
            buf.func_150787_b(inst.getLevel());
            buf.func_150787_b(count.intValue());
        });
    }

    public static EnchantmentPacket decode(PacketBuffer buf) {
        boolean open = buf.readBoolean();
        Object2IntArrayMap enchantments = new Object2IntArrayMap();
        int enchantmentCount = buf.func_150792_a();
        for (int i = 0; i < enchantmentCount; ++i) {
            ResourceLocation enchantment = buf.func_192575_l();
            int level = buf.func_150792_a();
            int count = buf.func_150792_a();
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(enchantment)) continue;
            enchantments.put((Object)new EnchantmentInstance((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment), level), count);
        }
        return new EnchantmentPacket((Object2IntMap<EnchantmentInstance>)enchantments, open);
    }

    public static void handle(EnchantmentPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> EnchantmentMachineMod.PROXY.handleEnchantmentPacket(msg));
        ctx.setPacketHandled(true);
    }
}

