/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.tiles;

import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.inventory.DisenchanterContainer;
import de.cheaterpaul.enchantmentmachine.tiles.EnchantmentBaseTileEntity;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ISidedInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.tileentity.HopperTileEntity;
import net.minecraft.tileentity.IHopper;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;

public class DisenchanterTileEntity
extends EnchantmentBaseTileEntity
implements ITickableTileEntity,
ISidedInventory,
IHopper {
    private static final ITextComponent name = Utils.genTranslation("tile", "disenchanter.name");
    private static final int DURATION = 20;
    private final LazyOptional<? extends IItemHandler>[] itemHandler = SidedInvWrapper.create((ISidedInventory)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)2, (Object)ItemStack.field_190927_a);
    private int timer;
    private int transferCooldown;

    public DisenchanterTileEntity() {
        super(ModData.disenchanter_tile);
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        return name;
    }

    @Nonnull
    protected Container func_213906_a(int i, @Nonnull PlayerInventory playerInventory) {
        return new DisenchanterContainer(i, (IInventory)this, playerInventory);
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        return this.inventory.isEmpty();
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int i1) {
        ItemStack result = ItemStackHelper.func_188382_a(this.inventory, (int)i, (int)i1);
        this.setTimer();
        return result;
    }

    @Nonnull
    public ItemStack func_70304_b(int i) {
        ItemStack stack = ItemStackHelper.func_188383_a(this.inventory, (int)i);
        this.setTimer();
        return stack;
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
        this.setTimer();
    }

    private void setTimer() {
        this.timer = !this.func_70301_a(0).func_190926_b() && (this.func_70301_a(1).func_190926_b() || this.resultItem(this.func_70301_a(0)).func_77969_a(this.func_70301_a(1)) && this.func_70301_a(1).func_190916_E() + 1 <= this.func_70301_a(1).func_77976_d()) ? 20 : 0;
    }

    private ItemStack resultItem(ItemStack stack) {
        if (stack.func_77973_b() instanceof EnchantedBookItem) {
            return new ItemStack((IItemProvider)Items.field_151122_aG);
        }
        ItemStack stack1 = stack.func_77946_l();
        stack1.func_196082_o().func_82580_o("StoredEnchantments");
        EnchantmentHelper.func_82782_a(Collections.emptyMap(), (ItemStack)stack1);
        return stack1;
    }

    private Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        Map map = EnchantmentHelper.func_226652_a_((ListNBT)stack.func_77986_q());
        map.putAll(EnchantmentHelper.func_226652_a_((ListNBT)EnchantedBookItem.func_92110_g((ItemStack)stack)));
        return map;
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public double func_96107_aA() {
        return (double)this.field_174879_c.func_177958_n() + 0.5;
    }

    @Nonnull
    public int[] func_180463_a(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean func_94041_b(int index, @Nonnull ItemStack stack) {
        if (index == 0) {
            if (!((Boolean)ModConfig.SERVER.allowDisenchantingItems.get()).booleanValue() && EnchantedBookItem.func_92110_g((ItemStack)stack).isEmpty()) {
                return false;
            }
            return !EnchantmentHelper.func_82781_a((ItemStack)stack).isEmpty();
        }
        return false;
    }

    public boolean func_180462_a(int index, @Nonnull ItemStack itemStackIn, @Nullable Direction direction) {
        return index == 0 && this.func_94041_b(index, itemStackIn);
    }

    public boolean func_180461_b(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return index == 1;
    }

    @Override
    public void func_230337_a_(BlockState state, CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.inventory.clear();
        ItemStackHelper.func_191283_b((CompoundNBT)nbt, this.inventory);
    }

    @Override
    public CompoundNBT func_189515_b(CompoundNBT compound) {
        super.func_189515_b(compound);
        ItemStackHelper.func_191282_a((CompoundNBT)compound, this.inventory);
        return compound;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }

    @Nullable
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (!this.field_145846_f && facing != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.itemHandler[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.itemHandler[1].cast();
            }
            return this.itemHandler[2].cast();
        }
        return super.getCapability(cap, facing);
    }

    public void func_145843_s() {
        super.func_145843_s();
        for (LazyOptional<? extends IItemHandler> opt : this.itemHandler) {
            opt.invalidate();
        }
    }

    public double func_96109_aB() {
        return (double)this.field_174879_c.func_177956_o() + 0.5;
    }

    public double func_96108_aC() {
        return (double)this.field_174879_c.func_177952_p() + 0.5;
    }

    public void func_73660_a() {
        if (this.timer > 0 && this.hasConnectedTE() && --this.timer == 0) {
            this.getConnectedEnchantmentTE().ifPresent(te -> {
                ItemStack stack = (ItemStack)this.inventory.get(0);
                if (this.canDisenchant(stack)) {
                    Map<Enchantment, Integer> map = this.getEnchantments(stack);
                    map.forEach((key, value) -> {
                        EnchantmentInstance inst = new EnchantmentInstance((Enchantment)key, (int)value);
                        te.addEnchantment(inst);
                    });
                    stack = this.resultItem(stack);
                    ItemStack slot = this.func_70301_a(1);
                    if (!slot.func_190926_b() && slot.func_77969_a(stack)) {
                        stack.func_190918_g(-slot.func_190916_E());
                    }
                    this.func_70299_a(1, stack);
                    this.func_70299_a(0, ItemStack.field_190927_a);
                }
            });
        }
        if (this.field_145850_b != null && !this.field_145850_b.field_72995_K) {
            --this.transferCooldown;
            if (this.transferCooldown <= 0) {
                this.transferCooldown = 0;
                if (HopperTileEntity.func_145891_a((IHopper)this)) {
                    this.transferCooldown = 0;
                }
            }
        }
    }

    private boolean canDisenchant(ItemStack stack) {
        return (Boolean)ModConfig.SERVER.allowDisenchantingItems.get() != false || !EnchantedBookItem.func_92110_g((ItemStack)stack).isEmpty();
    }
}

