/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.tiles;

import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.inventory.EnchanterContainer;
import de.cheaterpaul.enchantmentmachine.tiles.EnchantmentBaseTileEntity;
import de.cheaterpaul.enchantmentmachine.tiles.StorageTileEntity;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.EnchantmentData;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.IInventory;
import net.minecraft.inventory.ItemStackHelper;
import net.minecraft.inventory.container.Container;
import net.minecraft.item.EnchantedBookItem;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.IWorldPosCallable;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.world.World;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchanterTileEntity
extends EnchantmentBaseTileEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ITextComponent name = Utils.genTranslation("tile", "enchanter.name");
    private final NonNullList<ItemStack> inventory = NonNullList.func_191197_a((int)1, (Object)ItemStack.field_190927_a);

    public EnchanterTileEntity() {
        super(ModData.enchanter_tile);
    }

    @Nonnull
    protected ITextComponent func_213907_g() {
        return name;
    }

    @Nonnull
    protected Container func_213906_a(int i, @Nonnull PlayerInventory playerInventory) {
        return new EnchanterContainer(i, (IInventory)this, playerInventory, IWorldPosCallable.func_221488_a((World)this.field_145850_b, (BlockPos)this.field_174879_c));
    }

    public int func_70302_i_() {
        return this.inventory.size();
    }

    public boolean func_191420_l() {
        for (ItemStack item : this.inventory) {
            if (item.func_190926_b()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack func_70301_a(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    @Nonnull
    public ItemStack func_70298_a(int i, int i1) {
        return ItemStackHelper.func_188382_a(this.inventory, (int)i, (int)i1);
    }

    @Nonnull
    public ItemStack func_70304_b(int i) {
        return ItemStackHelper.func_188383_a(this.inventory, (int)i);
    }

    public void func_70299_a(int i, @Nonnull ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (itemStack.func_190916_E() > this.func_70297_j_()) {
            itemStack.func_190920_e(this.func_70297_j_());
        }
    }

    public void func_174888_l() {
        this.inventory.clear();
    }

    public boolean executeEnchantments(PlayerEntity user, List<EnchantmentInstance> enchantments) {
        boolean book;
        if (!this.getConnectedEnchantmentTE().isPresent()) {
            return false;
        }
        ItemStack stack = (ItemStack)this.inventory.get(0);
        if (stack.func_190926_b()) {
            return false;
        }
        Map enchantmentMap = EnchantmentHelper.func_82781_a((ItemStack)stack);
        StorageTileEntity te = this.getConnectedEnchantmentTE().get();
        boolean bl = book = stack.func_77973_b() == Items.field_151122_aG || stack.func_77973_b() == Items.field_151134_bR;
        if (book) {
            stack = new ItemStack((IItemProvider)Items.field_151134_bR);
        }
        int requiredLevels = 0;
        for (EnchantmentInstance enchInst : enchantments) {
            if (!te.hasEnchantment(enchInst)) {
                LOGGER.warn("Enchantment {} requested but not available", (Object)enchInst);
                return false;
            }
            if (!enchInst.getEnchantment().func_92089_a(stack) && !book) {
                LOGGER.warn("Enchantment {} cannot be applied to {}", (Object)enchInst.getEnchantment(), (Object)stack);
                return false;
            }
            Pair<EnchantmentInstance, Integer> result = Utils.tryApplyEnchantment(enchInst, enchantmentMap, true);
            if (result == null) {
                return false;
            }
            requiredLevels += ((Integer)result.getRight()).intValue();
            enchantmentMap.put(((EnchantmentInstance)result.getLeft()).getEnchantment(), ((EnchantmentInstance)result.getLeft()).getLevel());
        }
        if (!user.field_71075_bZ.field_75098_d) {
            if (user.field_71068_ca < requiredLevels) {
                LOGGER.warn("Not enough levels to enchant {} {}", (Object)requiredLevels, (Object)user.field_71068_ca);
                return false;
            }
            user.func_82242_a(-requiredLevels);
        }
        if (book) {
            ItemStack finalStack = stack;
            enchantmentMap.forEach((ench, lvl) -> EnchantedBookItem.func_92115_a((ItemStack)finalStack, (EnchantmentData)new EnchantmentData(ench, lvl.intValue())));
            this.inventory.set(0, (Object)stack);
        } else {
            EnchantmentHelper.func_82782_a((Map)enchantmentMap, (ItemStack)stack);
        }
        enchantments.forEach(te::consumeEnchantment);
        return true;
    }

    @Nonnull
    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket pkt) {
        this.func_230337_a_(this.field_145850_b.func_180495_p(pkt.func_179823_a()), pkt.func_148857_g());
    }
}

