/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.tiles;

import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.tiles.IEnchantmentMachine;
import de.cheaterpaul.enchantmentmachine.tiles.StorageTileEntity;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.tileentity.LockableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.tileentity.TileEntityType;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IWorldReader;

public abstract class EnchantmentBaseTileEntity
extends LockableTileEntity
implements IEnchantmentMachine {
    @Nullable
    private BlockPos storageBlockPos;

    public EnchantmentBaseTileEntity(TileEntityType<?> tileEntityType) {
        super(tileEntityType);
    }

    public boolean func_70300_a(@Nonnull PlayerEntity playerEntity) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        return playerEntity.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) <= 64.0;
    }

    @Override
    public Optional<StorageTileEntity> getConnectedEnchantmentTE() {
        if (this.storageBlockPos == null) {
            return Optional.empty();
        }
        TileEntity te = this.field_145850_b.func_175625_s(this.storageBlockPos);
        if (te instanceof StorageTileEntity) {
            return Optional.of((StorageTileEntity)te);
        }
        return Optional.empty();
    }

    public void onNeighbourChanged(IWorldReader iWorld, BlockPos neighborPos) {
        if (this.storageBlockPos == null) {
            if (iWorld.func_180495_p(neighborPos).func_177230_c() == ModData.storage_block) {
                this.storageBlockPos = neighborPos;
            }
        } else if (this.storageBlockPos.equals((Object)neighborPos) && iWorld.func_180495_p(neighborPos).func_177230_c() != ModData.storage_block) {
            this.storageBlockPos = null;
        }
    }

    @Override
    public boolean hasConnectedTE() {
        return this.storageBlockPos != null;
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        super.func_189515_b(compound);
        if (this.storageBlockPos != null) {
            compound.func_74783_a("storageblock", new int[]{this.storageBlockPos.func_177958_n(), this.storageBlockPos.func_177956_o(), this.storageBlockPos.func_177952_p()});
        }
        return compound;
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        if (nbt.func_74764_b("storageblock")) {
            int[] pos = nbt.func_74759_k("storageblock");
            this.storageBlockPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
    }
}

