/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.tiles;

import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.tiles.IEnchantmentMachine;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Optional;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.block.BlockState;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.nbt.ListNBT;
import net.minecraft.tileentity.ITickableTileEntity;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.ResourceLocationException;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.text.ITextComponent;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class StorageTileEntity
extends TileEntity
implements IEnchantmentMachine,
ITickableTileEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final ITextComponent name = Utils.genTranslation("tile", "enchantment.name");
    private static final Random random = new Random();
    private final WeakHashMap<IEnchantmentListener, IEnchantmentListener> listeners = new WeakHashMap();
    private final Object2IntArrayMap<EnchantmentInstance> enchantmentMaps = new Object2IntArrayMap();
    public int ticks;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    public float nextPageAngle;
    public float pageAngle;
    public float tRot;

    public StorageTileEntity() {
        super(ModData.storage_tile);
    }

    public void addEnchantment(EnchantmentInstance enchInst, int count) {
        int c = this.enchantmentMaps.getOrDefault((Object)enchInst, 0);
        this.enchantmentMaps.put((Object)enchInst, c + count);
        this.notifyListeners();
    }

    public void func_73660_a() {
        float f2;
        this.pageTurningSpeed = this.nextPageTurningSpeed;
        this.pageAngle = this.nextPageAngle;
        PlayerEntity playerentity = this.field_145850_b.func_217366_a((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5, 3.0, false);
        if (playerentity != null) {
            double d0 = playerentity.func_226277_ct_() - ((double)this.field_174879_c.func_177958_n() + 0.5);
            double d1 = playerentity.func_226281_cx_() - ((double)this.field_174879_c.func_177952_p() + 0.5);
            this.tRot = (float)MathHelper.func_181159_b((double)d1, (double)d0);
            this.nextPageTurningSpeed += 0.1f;
            if (this.nextPageTurningSpeed < 0.5f || random.nextInt(40) == 0) {
                float f1 = this.flipT;
                do {
                    this.flipT += (float)(random.nextInt(4) - random.nextInt(4));
                } while (f1 == this.flipT);
            }
        } else {
            this.tRot += 0.02f;
            this.nextPageTurningSpeed -= 0.1f;
        }
        while (this.nextPageAngle >= (float)Math.PI) {
            this.nextPageAngle -= (float)Math.PI * 2;
        }
        while (this.nextPageAngle < (float)(-Math.PI)) {
            this.nextPageAngle += (float)Math.PI * 2;
        }
        while (this.tRot >= (float)Math.PI) {
            this.tRot -= (float)Math.PI * 2;
        }
        while (this.tRot < (float)(-Math.PI)) {
            this.tRot += (float)Math.PI * 2;
        }
        for (f2 = this.tRot - this.nextPageAngle; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        this.nextPageAngle += f2 * 0.4f;
        this.nextPageTurningSpeed = MathHelper.func_76131_a((float)this.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        ++this.ticks;
        this.oFlip = this.flip;
        float f = (this.flipT - this.flip) * 0.4f;
        float f3 = 0.2f;
        f = MathHelper.func_76131_a((float)f, (float)-0.2f, (float)0.2f);
        this.flipA += (f - this.flipA) * 0.9f;
        this.flip += this.flipA;
    }

    public int getTicks() {
        return this.ticks;
    }

    public boolean consumeEnchantment(EnchantmentInstance enchInst) {
        int count = this.enchantmentMaps.getOrDefault((Object)enchInst, 0);
        if (count <= 0) {
            return false;
        }
        if (count == 1) {
            this.enchantmentMaps.removeInt((Object)enchInst);
        } else {
            this.enchantmentMaps.put((Object)enchInst, count - 1);
        }
        this.notifyListeners();
        return true;
    }

    public void addEnchantment(EnchantmentInstance enchInst) {
        this.addEnchantment(enchInst, 1);
    }

    public void registerListener(IEnchantmentListener listener) {
        this.listeners.put(listener, listener);
    }

    public boolean hasEnchantment(EnchantmentInstance enchInst) {
        return this.enchantmentMaps.getOrDefault((Object)enchInst, 0) > 0;
    }

    public Object2IntMap<EnchantmentInstance> getEnchantments() {
        return Object2IntMaps.unmodifiable(this.enchantmentMaps);
    }

    public int getEnchantmentCount() {
        return this.enchantmentMaps.values().stream().mapToInt(s -> s).sum();
    }

    public void func_230337_a_(@Nonnull BlockState state, @Nonnull CompoundNBT nbt) {
        super.func_230337_a_(state, nbt);
        this.enchantmentMaps.clear();
        nbt.func_150295_c("enchantments", 10).forEach(i -> {
            CompoundNBT entry = (CompoundNBT)i;
            try {
                ResourceLocation eID = new ResourceLocation(entry.func_74779_i("id"));
                int level = entry.func_74762_e("level");
                int count = entry.func_74762_e("count");
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(eID);
                if (enchantment == null) {
                    LOGGER.info("Cannot find stored enchantment {} in registry", (Object)eID);
                } else {
                    EnchantmentInstance inst = new EnchantmentInstance(enchantment, level);
                    if (this.enchantmentMaps.containsKey((Object)inst)) {
                        LOGGER.warn("Multiple entries of the same enchantment instance in NBT");
                    }
                    this.enchantmentMaps.put((Object)inst, count);
                }
            }
            catch (NullPointerException | ResourceLocationException e) {
                LOGGER.error("Illegal enchantment id in NBT {} {}", (Object)entry.func_74779_i("id"), (Object)e);
            }
        });
    }

    @Nonnull
    public CompoundNBT func_189515_b(@Nonnull CompoundNBT compound) {
        compound = super.func_189515_b(compound);
        this.writeEnchantments(compound);
        return compound;
    }

    public void writeEnchantments(CompoundNBT compound) {
        ListNBT enchantments = new ListNBT();
        this.enchantmentMaps.forEach((inst, count) -> {
            CompoundNBT enchantment = new CompoundNBT();
            enchantment.func_74778_a("id", inst.getEnchantment().getRegistryName().toString());
            enchantment.func_74768_a("level", inst.getLevel());
            enchantment.func_74768_a("count", count.intValue());
            enchantments.add((Object)enchantment);
        });
        compound.func_218657_a("enchantments", (INBT)enchantments);
    }

    @Override
    public Optional<StorageTileEntity> getConnectedEnchantmentTE() {
        return Optional.of(this);
    }

    @Override
    public boolean hasConnectedTE() {
        return true;
    }

    public void removeListener(IEnchantmentListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        Object2IntMap<EnchantmentInstance> list = this.getEnchantments();
        this.listeners.forEach((k, v) -> v.onEnchantmentsChanged(list));
    }

    public static interface IEnchantmentListener {
        public void onEnchantmentsChanged(Object2IntMap<EnchantmentInstance> var1);
    }
}

