/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.util;

import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.ResourceLocation;
import org.apache.commons.lang3.tuple.Pair;

public class EnchantmentInstance {
    @Nonnull
    private final Enchantment enchantment;
    private final int level;

    public EnchantmentInstance(@Nonnull Enchantment enchantment, int level) {
        this.enchantment = enchantment;
        this.level = level;
    }

    public int getLevel() {
        return this.level;
    }

    @Nonnull
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnchantmentInstance that = (EnchantmentInstance)o;
        return this.level == that.level && this.enchantment.equals(that.enchantment);
    }

    public int hashCode() {
        return Objects.hash(this.enchantment, this.level);
    }

    public String toString() {
        return "EnchantmentInstance{enchantment=" + this.enchantment + ", level=" + this.level + '}';
    }

    public boolean canEnchant() {
        return ((List)ModConfig.SERVER.maxEnchantmentLevels.get()).stream().map(s -> {
            String[] maxlvels = s.split("\\|");
            return Pair.of((Object)new ResourceLocation(maxlvels[0]), (Object)Integer.parseInt(maxlvels[1]));
        }).filter(e -> ((ResourceLocation)e.getKey()).equals((Object)this.enchantment.getRegistryName())).noneMatch(a -> (Integer)a.getValue() < this.level);
    }
}

