/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.util;

import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstance;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.fml.ModList;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;

public class Utils {
    private static boolean apotheosisLoaded = false;

    public static void updateMods() {
        apotheosisLoaded = ModList.get().isLoaded("apotheosis");
    }

    public static String genLangKey(String type, String key) {
        return type + "." + "enchantmentmachine" + "." + key;
    }

    public static ITextComponent genTranslation(String type, String key) {
        return new TranslationTextComponent(Utils.genLangKey(type, key));
    }

    @Nullable
    public static Pair<EnchantmentInstance, Integer> tryApplyEnchantment(EnchantmentInstance enchInst, Map<Enchantment, Integer> existingEnchantments, boolean reducedPrice) {
        for (Map.Entry<Enchantment, Integer> entry : existingEnchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == enchInst.getEnchantment()) {
                int newLevel = Math.min(Utils.getEnchantmentMaxLevel(enchantment), enchInst.getLevel() == entry.getValue().intValue() ? enchInst.getLevel() + 1 : Math.max(enchInst.getLevel(), entry.getValue()));
                enchInst = new EnchantmentInstance(enchantment, newLevel);
                continue;
            }
            if (enchInst.getEnchantment().func_191560_c(enchantment) || ((Boolean)ModConfig.SERVER.allowMixtureEnchantments.get()).booleanValue()) continue;
            return null;
        }
        if (!enchInst.canEnchant()) {
            return null;
        }
        int baseCost = 0;
        switch (enchInst.getEnchantment().func_77324_c()) {
            case COMMON: {
                baseCost = 1;
                break;
            }
            case UNCOMMON: {
                baseCost = 2;
                break;
            }
            case RARE: {
                baseCost = 4;
                break;
            }
            case VERY_RARE: {
                baseCost = 8;
            }
        }
        if (reducedPrice) {
            baseCost = Math.max(1, baseCost / 2);
        }
        return Pair.of((Object)enchInst, (Object)(baseCost * enchInst.getLevel()));
    }

    public static int getEnchantmentMaxLevel(Enchantment enchantment) {
        if (apotheosisLoaded) {
            try {
                Class<?> c = Class.forName("shadows.apotheosis.ench.asm.EnchHooks");
                Method m = c.getMethod("getMaxLevel", Enchantment.class);
                return (Integer)m.invoke(null, enchantment);
            }
            catch (ClassNotFoundException | IllegalAccessException | NoSuchMethodException | InvocationTargetException e) {
                LogManager.getLogger((String)"EnchantmentMachine").error("Could not get max enchantment level from Apotheosis. Please report this.");
            }
        }
        return enchantment.func_77325_b();
    }
}

