/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.client.gui.screens;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cheaterpaul.enchantmentmachine.client.gui.components.ScrollableListButton;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.Screen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class StorageScreen
extends Screen {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("enchantmentmachine", "textures/gui/container/enchantment.png");
    private final int xSize = 197;
    private final int ySize = 222;
    private Object2IntMap<EnchantmentInstanceMod> enchantments = new Object2IntArrayMap();
    private ScrollableListButton<Pair<EnchantmentInstanceMod, Integer>> list;
    private int guiLeft;
    private int guiTop;

    public StorageScreen() {
        super((Component)new TextComponent("Enchantments"));
    }

    public void m_6574_(@Nonnull Minecraft minecraft, int p_231152_2_, int p_231152_3_) {
        int scrolled = this.list.getScrolled();
        super.m_6574_(minecraft, p_231152_2_, p_231152_3_);
        this.updateEnchantments(this.enchantments);
        this.list.setScrolled(scrolled);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.guiLeft = (this.f_96543_ - this.xSize) / 2;
        this.guiTop = (this.f_96544_ - this.ySize) / 2;
        this.list = new ScrollableListButton<Pair>(this.guiLeft + 10, this.guiTop + 10, this.xSize - 20, this.ySize - 20, 21, x$0 -> new EnchantmentItem((Pair<EnchantmentInstanceMod, Integer>)x$0));
        this.m_142416_((GuiEventListener)this.list);
    }

    public boolean m_7043_() {
        return false;
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int i = this.guiLeft;
        int j = this.guiTop;
        this.m_93228_(matrixStack, i, j, 0, 0, this.xSize, this.ySize);
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
    }

    public void updateEnchantments(Object2IntMap<EnchantmentInstanceMod> enchantments) {
        this.enchantments = enchantments;
        this.list.setItems(enchantments.object2IntEntrySet().stream().map(s -> Pair.of((Object)((EnchantmentInstanceMod)s.getKey()), (Object)s.getIntValue())).collect(Collectors.toSet()));
    }

    private class EnchantmentItem
    extends ScrollableListButton.ListItem<Pair<EnchantmentInstanceMod, Integer>> {
        private final ItemStack bookStack;
        private final Component name;

        public EnchantmentItem(Pair<EnchantmentInstanceMod, Integer> item) {
            super(item);
            this.bookStack = new ItemStack((ItemLike)Items.f_42690_, ((Integer)item.getRight()).intValue());
            EnchantmentHelper.m_44865_(Collections.singletonMap(((EnchantmentInstanceMod)item.getKey()).getEnchantment(), ((EnchantmentInstanceMod)item.getKey()).getLevel()), (ItemStack)this.bookStack);
            this.name = ((MutableComponent)((EnchantmentInstanceMod)item.getKey()).getEnchantment().m_44700_(((EnchantmentInstanceMod)item.getKey()).getLevel())).m_130938_(style -> style.m_131135_().m_131265_() == ChatFormatting.GRAY.m_126665_().intValue() ? style.m_131157_(ChatFormatting.WHITE) : style);
        }

        @Override
        public void render(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float partialTicks, float zLevel) {
            super.render(matrixStack, x, y, listWidth, listHeight, itemHeight, yOffset, mouseX, mouseY, partialTicks, zLevel);
            StorageScreen.this.f_96542_.m_115218_(this.bookStack, x + 5, y + 2 + yOffset);
            StorageScreen.this.f_96547_.m_92750_(matrixStack, this.name.getString(), (float)(x + 25), (float)(y + yOffset + 5), this.name.m_7383_().m_131135_().m_131265_());
            String count = String.valueOf(this.bookStack.m_41613_());
            StorageScreen.this.f_96547_.m_92750_(matrixStack, count, (float)(x + listWidth - 10), (float)(y + yOffset + 5), 0xFFFFFF);
        }

        @Override
        public void renderToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float zLevel) {
            if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + 222) {
                StorageScreen.this.m_6057_(matrixStack, this.bookStack, mouseX, mouseY);
            }
        }
    }
}

