/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.network.message;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.network.IMessage;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record EnchantingPacket(List<EnchantmentInstanceMod> enchantments) implements IMessage
{
    public static void encode(EnchantingPacket msg, FriendlyByteBuf buf) {
        buf.m_130130_(msg.enchantments.size());
        for (EnchantmentInstanceMod enchantment : msg.enchantments) {
            buf.m_130085_(enchantment.getEnchantment().getRegistryName());
            buf.m_130130_(enchantment.getLevel());
        }
    }

    public static EnchantingPacket decode(FriendlyByteBuf buf) {
        ArrayList<EnchantmentInstanceMod> enchantments = new ArrayList<EnchantmentInstanceMod>();
        int enchantmentCount = buf.m_130242_();
        for (int i = 0; i < enchantmentCount; ++i) {
            ResourceLocation enchantment = buf.m_130281_();
            int level = buf.m_130242_();
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(enchantment)) continue;
            enchantments.add(new EnchantmentInstanceMod((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment), level));
        }
        return new EnchantingPacket(enchantments);
    }

    public static void handle(EnchantingPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> EnchantmentMachineMod.PROXY.handleEnchantingPacket(msg, (Player)((NetworkEvent.Context)contextSupplier.get()).getSender()));
        ctx.setPacketHandled(true);
    }
}

