/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.network.message;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.network.IMessage;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Supplier;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraftforge.fmllegacy.network.NetworkEvent;
import net.minecraftforge.registries.ForgeRegistries;

public record EnchantmentPacket(Object2IntMap<EnchantmentInstanceMod> enchantments, boolean shouldOpenEnchantmentListScreen) implements IMessage
{
    public static void encode(EnchantmentPacket msg, FriendlyByteBuf buf) {
        buf.writeBoolean(msg.shouldOpenEnchantmentListScreen);
        buf.m_130130_(msg.enchantments.size());
        msg.enchantments.forEach((inst, count) -> {
            buf.m_130085_(inst.getEnchantment().getRegistryName());
            buf.m_130130_(inst.getLevel());
            buf.m_130130_(count.intValue());
        });
    }

    public static EnchantmentPacket decode(FriendlyByteBuf buf) {
        boolean open = buf.readBoolean();
        Object2IntArrayMap enchantments = new Object2IntArrayMap();
        int enchantmentCount = buf.m_130242_();
        for (int i = 0; i < enchantmentCount; ++i) {
            ResourceLocation enchantment = buf.m_130281_();
            int level = buf.m_130242_();
            int count = buf.m_130242_();
            if (!ForgeRegistries.ENCHANTMENTS.containsKey(enchantment)) continue;
            enchantments.put((Object)new EnchantmentInstanceMod((Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(enchantment), level), count);
        }
        return new EnchantmentPacket((Object2IntMap<EnchantmentInstanceMod>)enchantments, open);
    }

    public static void handle(EnchantmentPacket msg, Supplier<NetworkEvent.Context> contextSupplier) {
        NetworkEvent.Context ctx = contextSupplier.get();
        ctx.enqueueWork(() -> EnchantmentMachineMod.PROXY.handleEnchantmentPacket(msg));
        ctx.setPacketHandled(true);
    }
}

