/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.util;

import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.tuple.Pair;

public class Utils {
    public static String genLangKey(String type, String key) {
        return type + ".enchantmentmachine." + key;
    }

    public static Component genTranslation(String type, String key) {
        return new TranslatableComponent(Utils.genLangKey(type, key));
    }

    @Nullable
    public static Pair<EnchantmentInstanceMod, Integer> tryApplyEnchantment(EnchantmentInstanceMod enchInst, Map<Enchantment, Integer> existingEnchantments, boolean reducedPrice) {
        for (Map.Entry<Enchantment, Integer> entry : existingEnchantments.entrySet()) {
            Enchantment enchantment = entry.getKey();
            if (enchantment == enchInst.getEnchantment()) {
                int newLevel = Math.min(enchantment.m_6586_(), enchInst.getLevel() == entry.getValue().intValue() ? enchInst.getLevel() + 1 : Math.max(enchInst.getLevel(), entry.getValue()));
                enchInst = new EnchantmentInstanceMod(enchantment, newLevel);
                continue;
            }
            if (enchInst.getEnchantment().m_44695_(enchantment) || ((Boolean)ModConfig.SERVER.allowMixtureEnchantments.get()).booleanValue()) continue;
            return null;
        }
        if (!enchInst.canEnchant()) {
            return null;
        }
        int baseCost = switch (enchInst.getEnchantment().m_44699_()) {
            case Enchantment.Rarity.COMMON -> 1;
            case Enchantment.Rarity.UNCOMMON -> 2;
            case Enchantment.Rarity.RARE -> 4;
            case Enchantment.Rarity.VERY_RARE -> 8;
            default -> throw new IncompatibleClassChangeError();
        };
        if (reducedPrice) {
            baseCost = Math.max(1, baseCost / 2);
        }
        return Pair.of((Object)enchInst, (Object)(baseCost * enchInst.getLevel()));
    }
}

