/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block.entity;

import de.cheaterpaul.enchantmentmachine.block.entity.EnchantmentBaseBlockEntity;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.inventory.EnchanterContainerMenu;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import java.util.List;
import java.util.Map;
import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.EnchantmentInstance;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import org.apache.commons.lang3.tuple.Pair;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class EnchanterBlockEntity
extends EnchantmentBaseBlockEntity {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component name = Utils.genTranslation("tile", "enchanter.name");
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)1, (Object)ItemStack.f_41583_);

    public EnchanterBlockEntity(BlockPos pos, BlockState state) {
        super(ModData.enchanter_tile, pos, state);
    }

    @Nonnull
    protected Component m_6820_() {
        return name;
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int i, @Nonnull Inventory playerInventory) {
        return new EnchanterContainerMenu(i, (Container)this, playerInventory, ContainerLevelAccess.m_39289_((Level)this.f_58857_, (BlockPos)this.f_58858_));
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        for (ItemStack item : this.inventory) {
            if (item.m_41619_()) continue;
            return false;
        }
        return true;
    }

    @Nonnull
    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    @Nonnull
    public ItemStack m_7407_(int i, int i1) {
        return ContainerHelper.m_18969_(this.inventory, (int)i, (int)i1);
    }

    @Nonnull
    public ItemStack m_8016_(int i) {
        return ContainerHelper.m_18966_(this.inventory, (int)i);
    }

    public void m_6836_(int i, @Nonnull ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public boolean executeEnchantments(Player user, List<EnchantmentInstanceMod> enchantments) {
        boolean book;
        if (this.getConnectedEnchantmentTE().isEmpty()) {
            return false;
        }
        ItemStack stack = (ItemStack)this.inventory.get(0);
        if (stack.m_41619_()) {
            return false;
        }
        Map enchantmentMap = EnchantmentHelper.m_44831_((ItemStack)stack);
        StorageBlockEntity te = this.getConnectedEnchantmentTE().get();
        boolean bl = book = stack.m_41720_() == Items.f_42517_ || stack.m_41720_() == Items.f_42690_;
        if (book) {
            stack = new ItemStack((ItemLike)Items.f_42690_);
        }
        int requiredLevels = 0;
        for (EnchantmentInstanceMod enchInst : enchantments) {
            if (!te.hasEnchantment(enchInst)) {
                LOGGER.warn("Enchantment {} requested but not available", (Object)enchInst);
                return false;
            }
            if (!enchInst.getEnchantment().m_6081_(stack) && !book) {
                LOGGER.warn("Enchantment {} cannot be applied to {}", (Object)enchInst.getEnchantment(), (Object)stack);
                return false;
            }
            Pair<EnchantmentInstanceMod, Integer> result = Utils.tryApplyEnchantment(enchInst, enchantmentMap, true);
            if (result == null) {
                return false;
            }
            requiredLevels += ((Integer)result.getRight()).intValue();
            enchantmentMap.put(((EnchantmentInstanceMod)result.getLeft()).getEnchantment(), ((EnchantmentInstanceMod)result.getLeft()).getLevel());
        }
        if (!user.m_150110_().f_35937_) {
            if (user.f_36078_ < requiredLevels) {
                LOGGER.warn("Not enough levels to enchant {} {}", (Object)requiredLevels, (Object)user.f_36078_);
                return false;
            }
            user.m_6749_(-requiredLevels);
        }
        if (book) {
            ItemStack finalStack = stack;
            enchantmentMap.forEach((ench, lvl) -> EnchantedBookItem.m_41153_((ItemStack)finalStack, (EnchantmentInstance)new EnchantmentInstance(ench, lvl.intValue())));
            this.inventory.set(0, (Object)stack);
        } else {
            EnchantmentHelper.m_44865_((Map)enchantmentMap, (ItemStack)stack);
        }
        enchantments.forEach(te::consumeEnchantment);
        return true;
    }

    @Nonnull
    public CompoundTag m_5995_() {
        return this.m_187482_();
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }
}

