/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.client.gui.screens.inventory;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.client.gui.components.ScrollableListButton;
import de.cheaterpaul.enchantmentmachine.client.gui.screens.inventory.EnchantmentBaseScreen;
import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import de.cheaterpaul.enchantmentmachine.inventory.EnchanterContainerMenu;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantingPacket;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.ChatFormatting;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.ImageButton;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.apache.commons.lang3.tuple.Pair;

@OnlyIn(value=Dist.CLIENT)
public class EnchanterScreen
extends EnchantmentBaseScreen<EnchanterContainerMenu> {
    private static final ResourceLocation BACKGROUND = new ResourceLocation("enchantmentmachine", "textures/gui/container/enchanter.png");
    private final Map<EnchantmentInstanceMod, Pair<EnchantmentInstanceMod, Integer>> enchantments = new HashMap<EnchantmentInstanceMod, Pair<EnchantmentInstanceMod, Integer>>();
    private ScrollableListButton<Pair<EnchantmentInstanceMod, Integer>> list;
    private Map<Enchantment, Integer> itemEnchantments = new HashMap<Enchantment, Integer>();

    public EnchanterScreen(EnchanterContainerMenu container, Inventory playerInventory, Component name) {
        super(container, playerInventory, name);
        this.f_97726_ = 232;
        this.f_97727_ = 241;
        this.f_97730_ = 36;
        this.f_97731_ = this.f_97727_ - 94;
        container.setListener(this::refreshActiveEnchantments);
    }

    protected void m_7286_(@Nonnull PoseStack matrixStack, float partialTicks, int x, int y) {
        this.m_7333_(matrixStack);
        RenderSystem.m_157456_((int)0, (ResourceLocation)BACKGROUND);
        int i = this.f_97735_;
        int j = this.f_97736_;
        this.m_93228_(matrixStack, i, j, 0, 0, this.f_97726_, this.f_97727_);
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        super.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
        this.m_7025_(matrixStack, mouseX, mouseY);
    }

    protected void m_7856_() {
        super.m_7856_();
        this.list = new ScrollableListButton<Pair>(this.f_97735_ + 8, this.f_97736_ + 15, this.f_97726_ - 50, this.f_97727_ - 94 - 17, 21, x$0 -> new EnchantmentItem((Pair<EnchantmentInstanceMod, Integer>)x$0));
        this.m_142416_((GuiEventListener)this.list);
    }

    public void updateEnchantments(Object2IntMap<EnchantmentInstanceMod> enchantments) {
        this.enchantments.clear();
        enchantments.forEach((instance, integer) -> this.enchantments.put((EnchantmentInstanceMod)instance, (Pair<EnchantmentInstanceMod, Integer>)Pair.of((Object)instance, (Object)integer)));
        this.refreshActiveEnchantments();
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        super.m_7979_(mouseX, mouseY, button, dragX, dragY);
        if (!this.f_97738_) {
            this.list.m_7979_(mouseX, mouseY, button, dragX, dragY);
        }
        return true;
    }

    public void refreshActiveEnchantments() {
        ItemStack stack = ((EnchanterContainerMenu)this.f_97732_).m_38853_(0).m_7993_();
        this.itemEnchantments = EnchantmentHelper.m_44831_((ItemStack)stack);
        if (stack.m_41619_()) {
            this.list.setItems(this.enchantments.values());
        } else {
            this.list.setItems(this.enchantments.values().stream().filter(pair -> stack.m_41720_() == Items.f_42517_ || stack.m_41720_() == Items.f_42690_ || ((EnchantmentInstanceMod)pair.getKey()).getEnchantment().m_6081_(stack)).collect(Collectors.toList()));
        }
    }

    private void apply(EnchantmentInstanceMod instance) {
        if (((EnchanterContainerMenu)this.f_97732_).m_38853_(0).m_6657_() && (((Boolean)ModConfig.SERVER.allowMixtureEnchantments.get()).booleanValue() || EnchantmentHelper.m_44859_(this.itemEnchantments.keySet(), (Enchantment)instance.getEnchantment()) || this.hasEqualEnchantments(this.itemEnchantments, instance))) {
            EnchantmentMachineMod.DISPATCHER.sendToServer(new EnchantingPacket(Collections.singletonList(instance)));
            Pair<EnchantmentInstanceMod, Integer> value = this.enchantments.get(instance);
            if ((Integer)value.getValue() > 1) {
                this.enchantments.put(instance, (Pair<EnchantmentInstanceMod, Integer>)Pair.of((Object)instance, (Object)((Integer)value.getValue() - 1)));
            } else {
                this.enchantments.remove(instance);
            }
        }
        this.refreshActiveEnchantments();
    }

    private boolean hasEqualEnchantments(Map<Enchantment, Integer> itemEnchantments, EnchantmentInstanceMod enchantment) {
        for (Map.Entry<Enchantment, Integer> entry : itemEnchantments.entrySet()) {
            if (entry.getKey() != enchantment.getEnchantment() || entry.getKey().m_6586_() == entry.getValue().intValue() || entry.getValue() > enchantment.getLevel()) continue;
            return true;
        }
        return false;
    }

    private class EnchantmentItem
    extends ScrollableListButton.ListItem<Pair<EnchantmentInstanceMod, Integer>> {
        private final ItemStack bookStack;
        private final Component name;
        private final Button button;
        private final int requiredLevels;

        public EnchantmentItem(Pair<EnchantmentInstanceMod, Integer> item) {
            super(item);
            this.bookStack = new ItemStack((ItemLike)Items.f_42690_, ((Integer)item.getRight()).intValue());
            EnchantmentHelper.m_44865_(Collections.singletonMap(((EnchantmentInstanceMod)item.getKey()).getEnchantment(), ((EnchantmentInstanceMod)item.getKey()).getLevel()), (ItemStack)this.bookStack);
            this.name = ((MutableComponent)((EnchantmentInstanceMod)item.getKey()).getEnchantment().m_44700_(((EnchantmentInstanceMod)item.getKey()).getLevel())).m_130938_(style -> style.m_131135_().m_131265_() == ChatFormatting.GRAY.m_126665_().intValue() ? style.m_131157_(ChatFormatting.WHITE) : style);
            this.button = new ImageButton(0, 0, 11, 17, 1, 208, 18, new ResourceLocation("textures/gui/recipe_book.png"), 256, 256, button -> EnchanterScreen.this.apply((EnchantmentInstanceMod)item.getKey()), new Button.OnTooltip(){

                public void m_93752_(@Nonnull Button button, @Nonnull PoseStack matrixStack, int mouseX, int mouseY) {
                    if (mouseX > button.f_93620_ && mouseX < button.f_93620_ + button.m_5711_() && mouseY > button.f_93621_ && mouseY < button.f_93621_ + button.m_93694_()) {
                        MutableComponent text = EnchantmentItem.this.isCompatible() ? (EnchantmentItem.this.hasSufficientLevels() ? new TranslatableComponent("text.enchantmentmachine.enchant_for_level", new Object[]{EnchantmentItem.this.requiredLevels}).m_130940_(ChatFormatting.GREEN) : new TranslatableComponent("text.enchantmentmachine.require_level", new Object[]{EnchantmentItem.this.requiredLevels}).m_130940_(ChatFormatting.YELLOW)) : new TranslatableComponent("text.enchantmentmachine.unavailable").m_130940_(ChatFormatting.RED);
                        EnchanterScreen.this.m_96602_(matrixStack, (Component)text, mouseX, mouseY);
                    }
                }
            }, TextComponent.f_131282_);
            this.requiredLevels = this.calculateRequiredLevels();
        }

        @Override
        public boolean onClick(double mouseX, double mouseY) {
            if (!this.button.f_93624_) {
                return false;
            }
            if (mouseX > (double)this.button.f_93620_ && mouseX < (double)(this.button.f_93620_ + this.button.m_5711_()) && mouseY > (double)this.button.f_93621_ && mouseY < (double)(this.button.f_93621_ + this.button.m_93694_())) {
                if (this.isCompatible() && this.hasSufficientLevels()) {
                    this.button.m_5716_(mouseX, mouseY);
                }
                return true;
            }
            return false;
        }

        private boolean isCompatible() {
            EnchantmentInstanceMod s = (EnchantmentInstanceMod)((Pair)this.item).getKey();
            for (Map.Entry<Enchantment, Integer> entry : EnchanterScreen.this.itemEnchantments.entrySet()) {
                Enchantment enchantment = entry.getKey();
                if (enchantment != s.getEnchantment()) continue;
                int newLevel = Math.min(enchantment.m_6586_(), s.getLevel() == entry.getValue().intValue() ? s.getLevel() + 1 : Math.max(s.getLevel(), entry.getValue()));
                s = new EnchantmentInstanceMod(enchantment, newLevel);
            }
            return s.canEnchant() && ((Boolean)ModConfig.SERVER.allowMixtureEnchantments.get() != false || EnchantmentHelper.m_44859_(EnchanterScreen.this.itemEnchantments.keySet(), (Enchantment)((EnchantmentInstanceMod)((Pair)this.item).getKey()).getEnchantment()) || EnchanterScreen.this.hasEqualEnchantments(EnchanterScreen.this.itemEnchantments, (EnchantmentInstanceMod)((Pair)this.item).getKey()));
        }

        @Override
        public void render(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float partialTicks, float zLevel) {
            super.render(matrixStack, x, y, listWidth, listHeight, itemHeight, yOffset, mouseX, mouseY, partialTicks, zLevel);
            EnchanterScreen.this.f_96542_.m_115218_(this.bookStack, x + 5, y + 2 + yOffset);
            EnchanterScreen.this.f_96547_.m_92750_(matrixStack, this.name.getString(), (float)(x + 25), (float)(y + yOffset + 5), this.name.m_7383_().m_131135_().m_131265_());
            String count = String.valueOf(this.bookStack.m_41613_());
            EnchanterScreen.this.f_96547_.m_92750_(matrixStack, count, (float)(x + listWidth - 20), (float)(y + yOffset + 5), 0xFFFFFF);
            this.button.f_93620_ = x + listWidth - 12;
            this.button.f_93621_ = y + yOffset + 2;
            this.button.f_93624_ = ((EnchanterContainerMenu)EnchanterScreen.this.f_97732_).m_38853_(0).m_6657_();
            if (this.isCompatible()) {
                if (this.hasSufficientLevels()) {
                    RenderSystem.m_157429_((float)0.2f, (float)1.0f, (float)0.4f, (float)1.0f);
                } else {
                    RenderSystem.m_157429_((float)0.5f, (float)0.4f, (float)0.2f, (float)1.0f);
                }
            } else {
                RenderSystem.m_157429_((float)1.0f, (float)0.2f, (float)0.4f, (float)1.0f);
            }
            matrixStack.m_85836_();
            this.button.m_6305_(matrixStack, mouseX, mouseY, partialTicks);
            matrixStack.m_85849_();
            RenderSystem.m_157429_((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }

        @Override
        public void renderToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float zLevel) {
            if (mouseX > x && mouseX < x + listWidth - 12 && mouseY > y && mouseY < y + itemHeight) {
                EnchanterScreen.this.m_6057_(matrixStack, this.bookStack, mouseX, mouseY);
            }
            if (this.button.f_93624_) {
                this.button.m_7428_(matrixStack, mouseX, mouseY);
            }
        }

        private int calculateRequiredLevels() {
            Pair<EnchantmentInstanceMod, Integer> result = Utils.tryApplyEnchantment((EnchantmentInstanceMod)((Pair)this.item).getKey(), EnchanterScreen.this.itemEnchantments, true);
            return result == null ? -1 : (Integer)result.getRight();
        }

        private boolean hasSufficientLevels() {
            return ((EnchanterContainerMenu)((EnchanterScreen)EnchanterScreen.this).f_97732_).getPlayer().f_36078_ >= this.requiredLevels || ((EnchanterContainerMenu)((EnchanterScreen)EnchanterScreen.this).f_97732_).getPlayer().m_150110_().f_35937_;
        }
    }
}

