/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.core;

import java.util.Collections;
import java.util.List;
import net.minecraft.ResourceLocationException;
import net.minecraft.resources.ResourceLocation;
import net.minecraftforge.common.ForgeConfigSpec;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.config.IConfigSpec;
import net.minecraftforge.fml.config.ModConfig;
import org.apache.commons.lang3.tuple.Pair;

public class ModConfig {
    public static final Server SERVER;
    private static final ForgeConfigSpec serverSpec;

    public static void init() {
        ModLoadingContext.get().registerConfig(ModConfig.Type.SERVER, (IConfigSpec)serverSpec);
    }

    static {
        Pair specPair = new ForgeConfigSpec.Builder().configure(Server::new);
        serverSpec = (ForgeConfigSpec)specPair.getRight();
        SERVER = (Server)specPair.getLeft();
    }

    public static class Server {
        public final ForgeConfigSpec.BooleanValue allowDisenchantingItems;
        public final ForgeConfigSpec.BooleanValue allowMixtureEnchantments;
        public final ForgeConfigSpec.ConfigValue<List<? extends String>> maxEnchantmentLevels;

        Server(ForgeConfigSpec.Builder builder) {
            builder.comment("Server configuration settings").push("server");
            this.allowDisenchantingItems = builder.comment("Whether items can be disenchanted. More vanilla like would be false").define("allowDisenchantingItems", true);
            this.allowMixtureEnchantments = builder.comment("Whether incompatible enchantments can be allied together").define("allowMixtureEnchantments", false);
            this.maxEnchantmentLevels = builder.comment("Define the max level for applying enchantments. Format is [\"enchantment_id|max_level\",\"enchantment_id|max_level\"]").defineList("maxEnchantmentLevels", Collections.emptyList(), string -> {
                if (string instanceof String) {
                    try {
                        String[] value = ((String)string).split("\\|");
                        new ResourceLocation(value[0]);
                        Integer.parseInt(value[1]);
                        return true;
                    }
                    catch (ArrayIndexOutOfBoundsException | NumberFormatException | ResourceLocationException e) {
                        return false;
                    }
                }
                return false;
            });
            builder.pop();
        }
    }
}

