/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.block.EnchantmentBaseBlock;
import de.cheaterpaul.enchantmentmachine.block.entity.EnchanterBlockEntity;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantmentPacket;
import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.MenuProvider;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import org.jetbrains.annotations.NotNull;

public class EnchanterBlock
extends EnchantmentBaseBlock {
    protected static final VoxelShape SHAPE = EnchanterBlock.makeShape();

    public EnchanterBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public boolean m_7923_(@Nonnull BlockState state) {
        return true;
    }

    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModData.enchanter_tile.m_155264_(pos, state);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState blockState, Level world, @Nonnull BlockPos blockPos, @Nonnull Player playerEntity, @Nonnull InteractionHand hand, @Nonnull BlockHitResult rayTraceResult) {
        BlockEntity tile = world.m_7702_(blockPos);
        if (tile instanceof EnchanterBlockEntity) {
            playerEntity.m_5893_((MenuProvider)((EnchanterBlockEntity)tile));
            if (!world.m_5776_() && playerEntity instanceof ServerPlayer) {
                Optional<StorageBlockEntity> s = ((EnchanterBlockEntity)tile).getConnectedEnchantmentTE();
                s.ifPresent(enchantmentTileEntity -> EnchantmentMachineMod.DISPATCHER.sendTo(new EnchantmentPacket(enchantmentTileEntity.getEnchantments(), false), (ServerPlayer)playerEntity));
            }
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_5871_(@NotNull ItemStack itemStack, @Nullable BlockGetter p_49817_, @NotNull List<Component> tooltips, @NotNull TooltipFlag flag) {
        super.m_5871_(itemStack, p_49817_, tooltips, flag);
        tooltips.add((Component)new TranslatableComponent("text.enchantmentmachine.next_to_storage_block", new Object[]{ModData.storage_block.m_49954_()}).m_130940_(ChatFormatting.GRAY));
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        VoxelShape a = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
        VoxelShape b = Block.m_49796_((double)2.0, (double)12.0, (double)2.0, (double)7.0, (double)15.0, (double)5.0);
        VoxelShape c = Block.m_49796_((double)9.0, (double)12.0, (double)11.0, (double)14.0, (double)15.0, (double)14.0);
        VoxelShape d = Block.m_49796_((double)4.0, (double)13.0, (double)5.0, (double)5.0, (double)14.0, (double)11.0);
        VoxelShape e = Block.m_49796_((double)11.0, (double)13.0, (double)5.0, (double)12.0, (double)14.0, (double)11.0);
        return Shapes.m_83124_((VoxelShape)a, (VoxelShape[])new VoxelShape[]{b, c, d, e});
    }
}

