/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.block.EnchantmentBaseBlock;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantmentPacket;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TranslatableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class StorageBlock
extends EnchantmentBaseBlock {
    protected static final VoxelShape SHAPE = StorageBlock.makeShape();

    public StorageBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return ModData.storage_tile.m_155264_(pos, state);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void m_5871_(@Nonnull ItemStack stack, @Nullable BlockGetter worldIn, @Nonnull List<Component> tooltip, @Nonnull TooltipFlag flagIn) {
        super.m_5871_(stack, worldIn, tooltip, flagIn);
        CompoundTag nbt = stack.m_41783_();
        int count = nbt != null ? nbt.m_128451_("enchantmentcount") : 0;
        tooltip.add((Component)new TranslatableComponent("text.enchantment_block.contained_enchantments", new Object[]{count}));
    }

    public void m_6240_(@Nonnull Level worldIn, @Nonnull Player player, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable BlockEntity te, @Nonnull ItemStack heldStack) {
        ItemStack stack = new ItemStack((ItemLike)ModData.storage_block, 1);
        if (te instanceof StorageBlockEntity) {
            ((StorageBlockEntity)te).writeEnchantments(stack.m_41698_("BlockEntityTag"));
            stack.m_41784_().m_128405_("enchantmentcount", ((StorageBlockEntity)te).getEnchantmentCount());
        }
        StorageBlock.m_49840_((Level)worldIn, (BlockPos)pos, (ItemStack)stack);
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState blockState, Level world, @Nonnull BlockPos blockPos, @Nonnull Player playerEntity, @Nonnull InteractionHand p_225533_5_, @Nonnull BlockHitResult p_225533_6_) {
        BlockEntity tile = world.m_7702_(blockPos);
        if (tile instanceof StorageBlockEntity && playerEntity instanceof ServerPlayer) {
            EnchantmentMachineMod.DISPATCHER.sendTo(new EnchantmentPacket(((StorageBlockEntity)tile).getEnchantments(), true), (ServerPlayer)playerEntity);
            return InteractionResult.CONSUME;
        }
        return InteractionResult.SUCCESS;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter worldIn, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return SHAPE;
    }

    public static VoxelShape makeShape() {
        return Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)12.0, (double)16.0);
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> type) {
        return StorageBlock.createStorageTicker(level, type, ModData.storage_tile);
    }

    protected static <T extends BlockEntity> BlockEntityTicker<T> createStorageTicker(Level level, BlockEntityType<T> type, BlockEntityType<? extends StorageBlockEntity> tile) {
        return level.f_46443_ ? StorageBlock.m_152132_(type, tile, StorageBlockEntity::clientTick) : null;
    }
}

