/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block.entity;

import de.cheaterpaul.enchantmentmachine.block.entity.EnchantmentBaseBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.inventory.DisenchanterContainerMenu;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import java.util.Collections;
import java.util.Map;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.network.Connection;
import net.minecraft.network.chat.Component;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.world.Container;
import net.minecraft.world.ContainerHelper;
import net.minecraft.world.WorldlyContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.EnchantedBookItem;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.Hopper;
import net.minecraft.world.level.block.entity.HopperBlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.SidedInvWrapper;
import org.jetbrains.annotations.NotNull;

public class DisenchanterBlockEntity
extends EnchantmentBaseBlockEntity
implements WorldlyContainer,
Hopper {
    private static final Component name = Utils.genTranslation("tile", "disenchanter.name");
    private static final int DURATION = 20;
    private final LazyOptional<? extends IItemHandler>[] itemHandler = SidedInvWrapper.create((WorldlyContainer)this, (Direction[])new Direction[]{Direction.UP, Direction.DOWN, Direction.NORTH});
    private final NonNullList<ItemStack> inventory = NonNullList.m_122780_((int)2, (Object)ItemStack.f_41583_);
    private int timer;
    private int transferCooldown;

    public DisenchanterBlockEntity(BlockPos pos, BlockState state) {
        super(ModData.disenchanter_tile, pos, state);
    }

    @Nonnull
    protected Component m_6820_() {
        return name;
    }

    @Nonnull
    protected AbstractContainerMenu m_6555_(int i, @Nonnull Inventory playerInventory) {
        return new DisenchanterContainerMenu(i, (Container)this, playerInventory);
    }

    public int m_6643_() {
        return this.inventory.size();
    }

    public boolean m_7983_() {
        return this.inventory.isEmpty();
    }

    @Nonnull
    public ItemStack m_8020_(int i) {
        return (ItemStack)this.inventory.get(i);
    }

    @Nonnull
    public ItemStack m_7407_(int i, int i1) {
        ItemStack result = ContainerHelper.m_18969_(this.inventory, (int)i, (int)i1);
        this.setTimer();
        return result;
    }

    @Nonnull
    public ItemStack m_8016_(int i) {
        ItemStack stack = ContainerHelper.m_18966_(this.inventory, (int)i);
        this.setTimer();
        return stack;
    }

    public void m_6836_(int i, @Nonnull ItemStack itemStack) {
        this.inventory.set(i, (Object)itemStack);
        if (itemStack.m_41613_() > this.m_6893_()) {
            itemStack.m_41764_(this.m_6893_());
        }
        this.setTimer();
    }

    private void setTimer() {
        this.timer = !this.m_8020_(0).m_41619_() && (this.m_8020_(1).m_41619_() || this.resultItem(this.m_8020_(0)).m_41656_(this.m_8020_(1)) && this.m_8020_(1).m_41613_() + 1 <= this.m_8020_(1).m_41741_()) ? 20 : 0;
    }

    private ItemStack resultItem(ItemStack stack) {
        if (stack.m_41720_() instanceof EnchantedBookItem) {
            return new ItemStack((ItemLike)Items.f_42517_);
        }
        ItemStack stack1 = stack.m_41777_();
        stack1.m_41784_().m_128473_("StoredEnchantments");
        EnchantmentHelper.m_44865_(Collections.emptyMap(), (ItemStack)stack1);
        return stack1;
    }

    private Map<Enchantment, Integer> getEnchantments(ItemStack stack) {
        Map map = EnchantmentHelper.m_44882_((ListTag)stack.m_41785_());
        map.putAll(EnchantmentHelper.m_44882_((ListTag)EnchantedBookItem.m_41163_((ItemStack)stack)));
        return map;
    }

    public void m_6211_() {
        this.inventory.clear();
    }

    public double m_6343_() {
        return (double)this.f_58858_.m_123341_() + 0.5;
    }

    @Nonnull
    public int[] m_7071_(@Nonnull Direction side) {
        if (side == Direction.DOWN) {
            return new int[]{1};
        }
        return new int[]{0};
    }

    public boolean m_7013_(int index, @Nonnull ItemStack stack) {
        if (index == 0) {
            if (!((Boolean)ModConfig.SERVER.allowDisenchantingItems.get()).booleanValue() && EnchantedBookItem.m_41163_((ItemStack)stack).isEmpty()) {
                return false;
            }
            return !EnchantmentHelper.m_44831_((ItemStack)stack).isEmpty();
        }
        return false;
    }

    public boolean m_7155_(int index, @Nonnull ItemStack itemStackIn, @Nullable Direction direction) {
        return index == 0 && this.m_7013_(index, itemStackIn);
    }

    public boolean m_7157_(int index, @Nonnull ItemStack stack, @Nonnull Direction direction) {
        return index == 1;
    }

    @Override
    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.inventory.clear();
        ContainerHelper.m_18980_((CompoundTag)nbt, this.inventory);
    }

    @Override
    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        ContainerHelper.m_18973_((CompoundTag)compound, this.inventory);
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        this.m_183515_(tag);
        return tag;
    }

    public void onDataPacket(Connection net, ClientboundBlockEntityDataPacket pkt) {
        this.m_142466_(pkt.m_131708_());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, Direction facing) {
        if (!this.f_58859_ && facing != null && cap == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            if (facing == Direction.UP) {
                return this.itemHandler[0].cast();
            }
            if (facing == Direction.DOWN) {
                return this.itemHandler[1].cast();
            }
            return this.itemHandler[2].cast();
        }
        return super.getCapability(cap, facing);
    }

    public void m_7651_() {
        super.m_7651_();
        for (LazyOptional<? extends IItemHandler> opt : this.itemHandler) {
            opt.invalidate();
        }
    }

    public double m_6358_() {
        return (double)this.f_58858_.m_123342_() + 0.5;
    }

    public double m_6446_() {
        return (double)this.f_58858_.m_123343_() + 0.5;
    }

    public static void serverTick(Level level, BlockPos blockPos, BlockState state, DisenchanterBlockEntity entity) {
        if (entity.timer > 0 && entity.hasConnectedTE() && --entity.timer == 0) {
            entity.getConnectedEnchantmentTE().ifPresent(te -> {
                ItemStack stack = (ItemStack)entity.inventory.get(0);
                if (entity.canDisenchant(stack)) {
                    Map<Enchantment, Integer> map = entity.getEnchantments(stack);
                    map.forEach((key, value) -> {
                        EnchantmentInstanceMod inst = new EnchantmentInstanceMod((Enchantment)key, (int)value);
                        te.addEnchantment(inst);
                    });
                    stack = entity.resultItem(stack);
                    ItemStack slot = entity.m_8020_(1);
                    if (!slot.m_41619_() && slot.m_41656_(stack)) {
                        stack.m_41774_(-slot.m_41613_());
                    }
                    entity.m_6836_(1, stack);
                    entity.m_6836_(0, ItemStack.f_41583_);
                }
            });
        }
        if (entity.f_58857_ != null) {
            --entity.transferCooldown;
            if (entity.transferCooldown <= 0) {
                entity.transferCooldown = 0;
                if (HopperBlockEntity.m_155552_((Level)level, (Hopper)entity)) {
                    entity.transferCooldown = 0;
                }
            }
        }
    }

    private boolean canDisenchant(ItemStack stack) {
        return (Boolean)ModConfig.SERVER.allowDisenchantingItems.get() != false || !EnchantedBookItem.m_41163_((ItemStack)stack).isEmpty();
    }
}

