/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block.entity;

import de.cheaterpaul.enchantmentmachine.block.entity.IEnchantmentMachine;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.entity.BaseContainerBlockEntity;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import org.jetbrains.annotations.NotNull;

public abstract class EnchantmentBaseBlockEntity
extends BaseContainerBlockEntity
implements IEnchantmentMachine {
    @Nullable
    private BlockPos storageBlockPos;

    public EnchantmentBaseBlockEntity(BlockEntityType<?> tileEntityType, BlockPos pos, BlockState state) {
        super(tileEntityType, pos, state);
    }

    public boolean m_6542_(@Nonnull Player playerEntity) {
        if (this.f_58857_.m_7702_(this.f_58858_) != this) {
            return false;
        }
        return playerEntity.m_20275_((double)this.f_58858_.m_123341_() + 0.5, (double)this.f_58858_.m_123342_() + 0.5, (double)this.f_58858_.m_123343_() + 0.5) <= 64.0;
    }

    @Override
    public Optional<StorageBlockEntity> getConnectedEnchantmentTE() {
        if (this.storageBlockPos == null) {
            return Optional.empty();
        }
        BlockEntity te = this.f_58857_.m_7702_(this.storageBlockPos);
        if (te instanceof StorageBlockEntity) {
            return Optional.of((StorageBlockEntity)te);
        }
        return Optional.empty();
    }

    public void onNeighbourChanged(LevelReader iWorld, BlockPos neighborPos) {
        if (this.storageBlockPos == null) {
            if (iWorld.m_8055_(neighborPos).m_60734_() == ModData.storage_block) {
                this.storageBlockPos = neighborPos;
            }
        } else if (this.storageBlockPos.equals((Object)neighborPos) && iWorld.m_8055_(neighborPos).m_60734_() != ModData.storage_block) {
            this.storageBlockPos = null;
        }
    }

    @Override
    public boolean hasConnectedTE() {
        return this.storageBlockPos != null;
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        super.m_183515_(compound);
        if (this.storageBlockPos != null) {
            compound.m_128385_("storageblock", new int[]{this.storageBlockPos.m_123341_(), this.storageBlockPos.m_123342_(), this.storageBlockPos.m_123343_()});
        }
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        if (nbt.m_128441_("storageblock")) {
            int[] pos = nbt.m_128465_("storageblock");
            this.storageBlockPos = new BlockPos(pos[0], pos[1], pos[2]);
        }
    }
}

