/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.client.gui.components;

import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraftforge.client.gui.GuiUtils;
import net.minecraftforge.client.gui.widget.ExtendedButton;

public class ScrollableListButton<T>
extends ExtendedButton {
    private static final ResourceLocation MISC = new ResourceLocation("enchantmentmachine", "textures/gui/misc.png");
    private final ItemCreator<T> itemSupplier;
    private final int itemHeight;
    private final int scrollerWidth = 9;
    private final List<ListItem<T>> listItems = new ArrayList<ListItem<T>>();
    private int scrolled;
    private double scrolledD;
    private boolean scrollerClicked;
    private boolean canScroll = true;

    public ScrollableListButton(int xPos, int yPos, int width, int height, int itemHeight) {
        this(xPos, yPos, width, height, itemHeight, ListItem::new);
    }

    public ScrollableListButton(int xPos, int yPos, int width, int height, int itemHeight, ItemCreator<T> itemSupplier) {
        super(xPos, yPos, width, height, (Component)new TextComponent(""), button -> {});
        this.itemHeight = itemHeight;
        this.itemSupplier = itemSupplier;
    }

    public void setItems(Collection<T> elements) {
        this.listItems.clear();
        elements.forEach(item -> this.listItems.add(this.itemSupplier.apply(item)));
        this.setScrolled(Mth.m_14045_((int)this.scrolled, (int)0, (int)Math.max(0, this.listItems.size() * this.itemHeight - this.f_93619_)));
        this.canScroll = this.listItems.size() * this.itemHeight > this.f_93619_;
    }

    public void addItem(T element) {
        this.listItems.add(this.itemSupplier.apply(element));
    }

    public void removeItem(T element) {
        this.listItems.removeIf(item -> item.item == element);
        if (this.scrolled > this.listItems.size() * this.itemHeight - this.f_93619_) {
            this.setScrolled(this.listItems.size() * this.itemHeight - this.f_93619_);
        }
    }

    public void setScrolled(int scrolled) {
        this.scrolled = scrolled;
        this.scrolledD = this.scrolled;
    }

    public int getScrolled() {
        return this.scrolled;
    }

    public void m_6305_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        matrixStack.m_85836_();
        RenderSystem.m_69482_();
        matrixStack.m_85837_(0.0, 0.0, 950.0);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ScrollableListButton.m_93172_((PoseStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.m_85837_(0.0, 0.0, -950.0);
        RenderSystem.m_69456_((int)518);
        matrixStack.m_85837_((double)this.f_93620_, (double)this.f_93621_, 0.0);
        ScrollableListButton.m_93172_((PoseStack)matrixStack, (int)this.f_93618_, (int)this.f_93619_, (int)0, (int)0, (int)-16711680);
        matrixStack.m_85837_((double)(-this.f_93620_), (double)(-this.f_93621_), 0.0);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        this.renderBackground(matrixStack, mouseX, mouseY, partialTicks);
        this.renderItems(matrixStack, mouseX, mouseY, partialTicks);
        RenderSystem.m_69482_();
        RenderSystem.m_69456_((int)518);
        matrixStack.m_85837_(0.0, 0.0, -950.0);
        RenderSystem.m_69444_((boolean)false, (boolean)false, (boolean)false, (boolean)false);
        ScrollableListButton.m_93172_((PoseStack)matrixStack, (int)4680, (int)2260, (int)-4680, (int)-2260, (int)-16777216);
        RenderSystem.m_69444_((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        matrixStack.m_85837_(0.0, 0.0, 950.0);
        RenderSystem.m_69456_((int)515);
        RenderSystem.m_69465_();
        matrixStack.m_85849_();
        this.m_7428_(matrixStack, mouseX, mouseY);
    }

    private void renderBackground(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        GuiUtils.drawContinuousTexturedBox((PoseStack)matrixStack, (ResourceLocation)new ResourceLocation("textures/gui/widgets.png"), (int)this.f_93620_, (int)this.f_93621_, (int)0, (int)46, (int)(this.f_93618_ - this.scrollerWidth + 1), (int)this.f_93619_, (int)200, (int)20, (int)3, (int)3, (int)3, (int)3, (float)this.m_93252_());
    }

    private void renderItems(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int itemHeight = this.itemHeight - 1;
        for (int i = 0; i < this.listItems.size(); ++i) {
            int y = i * itemHeight - this.scrolled;
            ListItem<T> item = this.listItems.get(i);
            item.render(matrixStack, this.f_93620_, this.f_93621_ + 1, this.f_93618_ - 9, this.f_93619_, this.itemHeight, y, mouseX, mouseY, partialTicks, this.m_93252_());
        }
        this.renderScrollBar(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderScrollBar(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        RenderSystem.m_157427_(GameRenderer::m_172817_);
        GuiUtils.drawContinuousTexturedBox((PoseStack)matrixStack, (ResourceLocation)MISC, (int)(this.f_93620_ + this.f_93618_ - this.scrollerWidth), (int)this.f_93621_, (int)0, (int)0, (int)9, (int)this.f_93619_, (int)9, (int)200, (int)2, (float)this.m_93252_());
        this.renderScroller(matrixStack, mouseX, mouseY, partialTicks);
    }

    private void renderScroller(PoseStack matrixStack, int mouseX, int mouseY, float partialTicks) {
        int scrollerHeight = 27;
        int scrollHeight = this.f_93619_ - 2 - scrollerHeight;
        float perc = (float)this.scrolled / (float)(this.listItems.size() * this.itemHeight - this.f_93619_);
        int yOffset = (int)((float)scrollHeight * perc);
        RenderSystem.m_157456_((int)0, (ResourceLocation)MISC);
        this.m_93228_(matrixStack, this.f_93620_ + this.f_93618_ - this.scrollerWidth + 1, this.f_93621_ + yOffset + 1, this.canScroll ? 9 : 16, 0, 7, 27);
    }

    public boolean m_6050_(double mouseX, double mouseY, double delta) {
        if (this.canScroll) {
            this.scrolled = Mth.m_14045_((int)(this.scrolled + 4 * (int)(-delta)), (int)0, (int)(this.listItems.size() * this.itemHeight - this.f_93619_));
            this.scrolledD = this.scrolled;
            return true;
        }
        return false;
    }

    public boolean m_7979_(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (this.canScroll && this.scrollerClicked) {
            double perc = dragY / (double)(this.f_93619_ - 27);
            double s = (double)(this.listItems.size() * this.itemHeight - this.f_93619_) * perc;
            this.scrolledD += s;
            this.scrolled = (int)this.scrolledD;
            this.scrolled = Mth.m_14045_((int)this.scrolled, (int)0, (int)(this.listItems.size() * this.itemHeight - this.f_93619_));
            return true;
        }
        return false;
    }

    public boolean m_6375_(double mouseX, double mouseY, int button) {
        this.scrolledD = this.scrolled;
        if (mouseX > (double)this.f_93620_ && mouseX < (double)(this.f_93620_ + this.f_93618_) && mouseY > (double)this.f_93621_ && mouseY < (double)(this.f_93621_ + this.f_93619_)) {
            if (mouseX > (double)(this.f_93620_ + this.f_93618_ - this.scrollerWidth)) {
                this.scrollerClicked = true;
            } else {
                int itemHeight = this.itemHeight - 1;
                for (int i = 0; i < this.listItems.size(); ++i) {
                    int y = i * itemHeight - this.scrolled;
                    if (y < -itemHeight) continue;
                    ListItem<T> item = this.listItems.get(i);
                    if (!(mouseX > (double)this.f_93620_) || !(mouseX < (double)(this.f_93620_ + this.f_93618_ - this.scrollerWidth)) || !(mouseY > (double)(this.f_93621_ + y)) || !(mouseY < (double)(this.f_93621_ + y + this.itemHeight)) || !item.onClick(mouseX, mouseY)) continue;
                    return true;
                }
            }
        }
        return super.m_6375_(mouseX, mouseY, button);
    }

    public void m_7428_(@Nonnull PoseStack matrixStack, int mouseX, int mouseY) {
        if (mouseX > this.f_93620_ && mouseX < this.f_93620_ + this.f_93618_ && mouseY > this.f_93621_ && mouseY < this.f_93621_ + this.f_93619_) {
            int itemHeight = this.itemHeight - 1;
            for (int i = 0; i < this.listItems.size(); ++i) {
                int y = i * itemHeight - this.scrolled;
                if (y < -itemHeight) continue;
                ListItem<T> item = this.listItems.get(i);
                item.preRenderToolTip(matrixStack, this.f_93620_, this.f_93621_ + y, this.f_93618_ - 9, this.f_93619_, this.itemHeight, y, mouseX, mouseY, this.m_93252_());
            }
        }
    }

    public boolean m_6348_(double mouseX, double mouseY, int button) {
        this.scrollerClicked = false;
        return super.m_6348_(mouseX, mouseY, button);
    }

    @FunctionalInterface
    public static interface ItemCreator<T> {
        public ListItem<T> apply(T var1);
    }

    public static class ListItem<T> {
        private static final ResourceLocation WIDGETS = new ResourceLocation("textures/gui/widgets.png");
        protected final T item;

        public ListItem(T item) {
            this.item = item;
        }

        public void render(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float partialTicks, float zLevel) {
            RenderSystem.m_157427_(GameRenderer::m_172817_);
            RenderSystem.m_69482_();
            GuiUtils.drawContinuousTexturedBox((PoseStack)matrixStack, (ResourceLocation)WIDGETS, (int)x, (int)(y + yOffset), (int)0, (int)66, (int)(listWidth + 1), (int)itemHeight, (int)200, (int)20, (int)3, (int)3, (int)3, (int)3, (float)zLevel);
            RenderSystem.m_69465_();
        }

        public void preRenderToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float zLevel) {
            int ySize = Mth.m_14045_((int)(listHeight - yOffset), (int)0, (int)itemHeight);
            if (mouseX > x && mouseX < x + listWidth && mouseY > y && mouseY < y + ySize) {
                this.renderToolTip(matrixStack, x, y, listWidth, listHeight, itemHeight, yOffset, mouseX, mouseY, zLevel);
            }
        }

        public void renderToolTip(PoseStack matrixStack, int x, int y, int listWidth, int listHeight, int itemHeight, int yOffset, int mouseX, int mouseY, float zLevel) {
        }

        public boolean onClick(double mouseX, double mouseY) {
            return false;
        }
    }
}

