/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.inventory;

import de.cheaterpaul.enchantmentmachine.EnchantmentMachineMod;
import de.cheaterpaul.enchantmentmachine.block.entity.EnchanterBlockEntity;
import de.cheaterpaul.enchantmentmachine.block.entity.StorageBlockEntity;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.inventory.EnchantmentBaseContainerMenu;
import de.cheaterpaul.enchantmentmachine.network.message.EnchantmentPacket;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;

public class EnchanterContainerMenu
extends EnchantmentBaseContainerMenu
implements StorageBlockEntity.IEnchantmentListener {
    private final ContainerLevelAccess worldPosCallable;
    private final Player player;
    private ISlotListener listener;
    private final Container menu;

    public EnchanterContainerMenu(int id, Inventory playerInventory) {
        this(id, (Container)new SimpleContainer(1), playerInventory, ContainerLevelAccess.f_39287_);
    }

    public EnchanterContainerMenu(int id, Container menu, Inventory playerInventory, ContainerLevelAccess worldPosCallable) {
        super(ModData.enchanter_container, id, 1);
        this.menu = menu;
        this.m_38897_(new Slot(menu, 0, 203, 19){

            public int m_6641_() {
                return 1;
            }

            public void m_6654_() {
                super.m_6654_();
                if (EnchanterContainerMenu.this.listener != null) {
                    EnchanterContainerMenu.this.listener.slotChanged();
                }
            }
        });
        this.addPlayerSlots(playerInventory, 36, 159);
        this.player = playerInventory.f_35978_;
        this.worldPosCallable = worldPosCallable;
        this.contactEnchantmentTileEntity(t -> t.registerListener(this));
    }

    public Player getPlayer() {
        return this.player;
    }

    public void m_6877_(@Nonnull Player playerIn) {
        super.m_6877_(playerIn);
        this.contactEnchantmentTileEntity(t -> t.removeListener(this));
        this.worldPosCallable.m_39292_((world, pos) -> this.m_150411_(playerIn, this.menu));
    }

    @Override
    public void onEnchantmentsChanged(Object2IntMap<EnchantmentInstanceMod> updatedList) {
        if (this.player instanceof ServerPlayer) {
            EnchantmentPacket p = new EnchantmentPacket(updatedList, false);
            EnchantmentMachineMod.DISPATCHER.sendTo(p, (ServerPlayer)this.player);
        }
    }

    public void setListener(ISlotListener listener) {
        this.listener = listener;
    }

    public ContainerLevelAccess getWorldPosCallable() {
        return this.worldPosCallable;
    }

    @Override
    @Nonnull
    public ItemStack m_7648_(@Nonnull Player playerEntity, int index) {
        return super.m_7648_(playerEntity, index);
    }

    private void contactEnchantmentTileEntity(Consumer<StorageBlockEntity> consumer) {
        this.worldPosCallable.m_39292_((w, p) -> {
            BlockEntity t = w.m_7702_(p);
            if (t instanceof EnchanterBlockEntity) {
                ((EnchanterBlockEntity)t).getConnectedEnchantmentTE().ifPresent(consumer);
            }
        });
    }

    @FunctionalInterface
    public static interface ISlotListener {
        public void slotChanged();
    }
}

