/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.block.entity;

import de.cheaterpaul.enchantmentmachine.block.entity.IEnchantmentMachine;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import de.cheaterpaul.enchantmentmachine.util.EnchantmentInstanceMod;
import de.cheaterpaul.enchantmentmachine.util.Utils;
import it.unimi.dsi.fastutil.objects.Object2IntArrayMap;
import it.unimi.dsi.fastutil.objects.Object2IntMap;
import it.unimi.dsi.fastutil.objects.Object2IntMaps;
import java.util.Optional;
import java.util.Random;
import java.util.WeakHashMap;
import javax.annotation.Nonnull;
import net.minecraft.ResourceLocationException;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.enchantment.Enchantment;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraftforge.registries.ForgeRegistries;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;

public class StorageBlockEntity
extends BlockEntity
implements IEnchantmentMachine {
    private static final Logger LOGGER = LogManager.getLogger();
    private static final Component name = Utils.genTranslation("tile", "enchantment.name");
    private static final Random random = new Random();
    private final WeakHashMap<IEnchantmentListener, IEnchantmentListener> listeners = new WeakHashMap();
    private final Object2IntArrayMap<EnchantmentInstanceMod> enchantmentMaps = new Object2IntArrayMap();
    public int ticks;
    public float flip;
    public float oFlip;
    public float flipT;
    public float flipA;
    public float nextPageTurningSpeed;
    public float pageTurningSpeed;
    public float nextPageAngle;
    public float pageAngle;
    public float tRot;

    public StorageBlockEntity(BlockPos blockPos, BlockState state) {
        super(ModData.storage_tile, blockPos, state);
    }

    public void addEnchantment(EnchantmentInstanceMod enchInst, int count) {
        int c = this.enchantmentMaps.getOrDefault((Object)enchInst, 0);
        this.enchantmentMaps.put((Object)enchInst, c + count);
        this.notifyListeners();
    }

    public static void clientTick(Level level, BlockPos blockPos, BlockState state, StorageBlockEntity entity) {
        float f2;
        entity.pageTurningSpeed = entity.nextPageTurningSpeed;
        entity.pageAngle = entity.nextPageAngle;
        Player playerentity = entity.f_58857_.m_45924_((double)entity.f_58858_.m_123341_() + 0.5, (double)entity.f_58858_.m_123342_() + 0.5, (double)entity.f_58858_.m_123343_() + 0.5, 3.0, false);
        if (playerentity != null) {
            double d0 = playerentity.m_20185_() - ((double)entity.f_58858_.m_123341_() + 0.5);
            double d1 = playerentity.m_20189_() - ((double)entity.f_58858_.m_123343_() + 0.5);
            entity.tRot = (float)Mth.m_14136_((double)d1, (double)d0);
            entity.nextPageTurningSpeed += 0.1f;
            if (entity.nextPageTurningSpeed < 0.5f || random.nextInt(40) == 0) {
                float f1 = entity.flipT;
                do {
                    entity.flipT += (float)(random.nextInt(4) - random.nextInt(4));
                } while (f1 == entity.flipT);
            }
        } else {
            entity.tRot += 0.02f;
            entity.nextPageTurningSpeed -= 0.1f;
        }
        while (entity.nextPageAngle >= (float)Math.PI) {
            entity.nextPageAngle -= (float)Math.PI * 2;
        }
        while (entity.nextPageAngle < (float)(-Math.PI)) {
            entity.nextPageAngle += (float)Math.PI * 2;
        }
        while (entity.tRot >= (float)Math.PI) {
            entity.tRot -= (float)Math.PI * 2;
        }
        while (entity.tRot < (float)(-Math.PI)) {
            entity.tRot += (float)Math.PI * 2;
        }
        for (f2 = entity.tRot - entity.nextPageAngle; f2 >= (float)Math.PI; f2 -= (float)Math.PI * 2) {
        }
        while (f2 < (float)(-Math.PI)) {
            f2 += (float)Math.PI * 2;
        }
        entity.nextPageAngle += f2 * 0.4f;
        entity.nextPageTurningSpeed = Mth.m_14036_((float)entity.nextPageTurningSpeed, (float)0.0f, (float)1.0f);
        ++entity.ticks;
        entity.oFlip = entity.flip;
        float f = (entity.flipT - entity.flip) * 0.4f;
        float f3 = 0.2f;
        f = Mth.m_14036_((float)f, (float)-0.2f, (float)0.2f);
        entity.flipA += (f - entity.flipA) * 0.9f;
        entity.flip += entity.flipA;
    }

    public int getTicks() {
        return this.ticks;
    }

    public boolean consumeEnchantment(EnchantmentInstanceMod enchInst) {
        int count = this.enchantmentMaps.getOrDefault((Object)enchInst, 0);
        if (count <= 0) {
            return false;
        }
        if (count == 1) {
            this.enchantmentMaps.removeInt((Object)enchInst);
        } else {
            this.enchantmentMaps.put((Object)enchInst, count - 1);
        }
        this.notifyListeners();
        return true;
    }

    public void addEnchantment(EnchantmentInstanceMod enchInst) {
        this.addEnchantment(enchInst, 1);
    }

    public void registerListener(IEnchantmentListener listener) {
        this.listeners.put(listener, listener);
    }

    public boolean hasEnchantment(EnchantmentInstanceMod enchInst) {
        return this.enchantmentMaps.getOrDefault((Object)enchInst, 0) > 0;
    }

    public Object2IntMap<EnchantmentInstanceMod> getEnchantments() {
        return Object2IntMaps.unmodifiable(this.enchantmentMaps);
    }

    public int getEnchantmentCount() {
        return this.enchantmentMaps.values().intStream().sum();
    }

    public void m_142466_(@Nonnull CompoundTag nbt) {
        super.m_142466_(nbt);
        this.enchantmentMaps.clear();
        nbt.m_128437_("enchantments", 10).forEach(i -> {
            CompoundTag entry = (CompoundTag)i;
            try {
                ResourceLocation eID = new ResourceLocation(entry.m_128461_("id"));
                int level = entry.m_128451_("level");
                int count = entry.m_128451_("count");
                Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(eID);
                if (enchantment == null) {
                    LOGGER.info("Cannot find stored enchantment {} in registry", (Object)eID);
                } else {
                    EnchantmentInstanceMod inst = new EnchantmentInstanceMod(enchantment, level);
                    if (this.enchantmentMaps.containsKey((Object)inst)) {
                        LOGGER.warn("Multiple entries of the same enchantment instance in NBT");
                    }
                    this.enchantmentMaps.put((Object)inst, count);
                }
            }
            catch (NullPointerException | ResourceLocationException e) {
                LOGGER.error("Illegal enchantment id in NBT {} {}", (Object)entry.m_128461_("id"), (Object)e);
            }
        });
    }

    protected void m_183515_(@NotNull CompoundTag compound) {
        this.writeEnchantments(compound);
    }

    public void writeEnchantments(CompoundTag compound) {
        ListTag enchantments = new ListTag();
        this.enchantmentMaps.forEach((inst, count) -> {
            CompoundTag enchantment = new CompoundTag();
            enchantment.m_128359_("id", inst.getEnchantment().getRegistryName().toString());
            enchantment.m_128405_("level", inst.getLevel());
            enchantment.m_128405_("count", count.intValue());
            enchantments.add((Object)enchantment);
        });
        compound.m_128365_("enchantments", (Tag)enchantments);
    }

    @Override
    public Optional<StorageBlockEntity> getConnectedEnchantmentTE() {
        return Optional.of(this);
    }

    @Override
    public boolean hasConnectedTE() {
        return true;
    }

    public void removeListener(IEnchantmentListener listener) {
        this.listeners.remove(listener);
    }

    private void notifyListeners() {
        Object2IntMap<EnchantmentInstanceMod> list = this.getEnchantments();
        this.listeners.forEach((k, v) -> v.onEnchantmentsChanged(list));
    }

    public static interface IEnchantmentListener {
        public void onEnchantmentsChanged(Object2IntMap<EnchantmentInstanceMod> var1);
    }
}

