/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.data;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.mojang.datafixers.util.Pair;
import de.cheaterpaul.enchantmentmachine.core.ModData;
import java.util.List;
import java.util.Map;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Supplier;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.advancements.CriterionTriggerInstance;
import net.minecraft.data.DataGenerator;
import net.minecraft.data.DataProvider;
import net.minecraft.data.loot.BlockLoot;
import net.minecraft.data.loot.LootTableProvider;
import net.minecraft.data.recipes.FinishedRecipe;
import net.minecraft.data.recipes.RecipeProvider;
import net.minecraft.data.recipes.ShapedRecipeBuilder;
import net.minecraft.data.tags.BlockTagsProvider;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.BlockTags;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.storage.loot.LootTable;
import net.minecraft.world.level.storage.loot.LootTables;
import net.minecraft.world.level.storage.loot.ValidationContext;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSet;
import net.minecraft.world.level.storage.loot.parameters.LootContextParamSets;
import net.minecraftforge.client.model.generators.BlockModelBuilder;
import net.minecraftforge.client.model.generators.BlockStateProvider;
import net.minecraftforge.client.model.generators.ItemModelBuilder;
import net.minecraftforge.client.model.generators.ItemModelProvider;
import net.minecraftforge.client.model.generators.ModelBuilder;
import net.minecraftforge.client.model.generators.ModelFile;
import net.minecraftforge.common.data.ExistingFileHelper;
import net.minecraftforge.forge.event.lifecycle.GatherDataEvent;

public class ModDataGenerator {
    public static void gatherData(GatherDataEvent event) {
        DataGenerator generator = event.getGenerator();
        if (event.includeClient()) {
            generator.m_123914_((DataProvider)new BlockStateGenerator(generator, event.getExistingFileHelper()));
            generator.m_123914_((DataProvider)new ItemModelGenerator(generator, event.getExistingFileHelper()));
        }
        generator.m_123914_((DataProvider)new ModLootTableProvider(generator));
        generator.m_123914_((DataProvider)new RecipeGenerator(generator));
        generator.m_123914_((DataProvider)new ModBlockTagsProvider(generator, event.getExistingFileHelper()));
    }

    public static class BlockStateGenerator
    extends BlockStateProvider {
        public BlockStateGenerator(DataGenerator gen, ExistingFileHelper exFileHelper) {
            super(gen, "enchantmentmachine", exFileHelper);
        }

        protected void registerStatesAndModels() {
            ModelFile.ExistingModelFile enchanter = new ModelFile.ExistingModelFile(this.blockTexture((Block)ModData.enchanter_block), this.models().existingFileHelper);
            ModelBuilder enchantment_block = ((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)((BlockModelBuilder)this.models().withExistingParent(ModData.storage_block.getRegistryName().toString(), "block/enchanting_table")).texture("particle", new ResourceLocation("enchantmentmachine", "block/enchanting_table_bottom"))).texture("top", new ResourceLocation("enchantmentmachine", "block/enchanting_table_top"))).texture("side", new ResourceLocation("enchantmentmachine", "block/enchanting_table_side"))).texture("bottom", new ResourceLocation("enchantmentmachine", "block/enchanting_table_bottom"));
            ModelFile.ExistingModelFile disenchanter = new ModelFile.ExistingModelFile(this.blockTexture((Block)ModData.disenchanter_block), this.models().existingFileHelper);
            this.simpleBlock((Block)ModData.enchanter_block, (ModelFile)enchanter);
            this.simpleBlock((Block)ModData.disenchanter_block, (ModelFile)disenchanter);
            this.simpleBlock((Block)ModData.storage_block, (ModelFile)enchantment_block);
        }
    }

    public static class ItemModelGenerator
    extends ItemModelProvider {
        public ItemModelGenerator(DataGenerator generator, ExistingFileHelper existingFileHelper) {
            super(generator, "enchantmentmachine", existingFileHelper);
        }

        protected void registerModels() {
            ((ItemModelBuilder)this.getBuilder(ModData.enchanter_block.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.enchanter_block.getRegistryName().m_135815_()));
            ((ItemModelBuilder)this.getBuilder(ModData.disenchanter_block.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.disenchanter_block.getRegistryName().m_135815_()));
            ((ItemModelBuilder)this.getBuilder(ModData.storage_block.getRegistryName().m_135815_())).parent((ModelFile)new ModelFile.UncheckedModelFile("enchantmentmachine:block/" + ModData.storage_block.getRegistryName().m_135815_()));
        }
    }

    private static class ModLootTableProvider
    extends LootTableProvider {
        public ModLootTableProvider(DataGenerator dataGeneratorIn) {
            super(dataGeneratorIn);
        }

        @Nonnull
        protected List<Pair<Supplier<Consumer<BiConsumer<ResourceLocation, LootTable.Builder>>>, LootContextParamSet>> getTables() {
            return ImmutableList.of((Object)Pair.of(Tables::new, (Object)LootContextParamSets.f_81421_));
        }

        protected void validate(Map<ResourceLocation, LootTable> map, @Nonnull ValidationContext validationContext) {
            map.forEach((resourceLocation, lootTable) -> LootTables.m_79202_((ValidationContext)validationContext, (ResourceLocation)resourceLocation, (LootTable)lootTable));
        }

        @Nonnull
        public String m_6055_() {
            return "EnchantmentMachine Loot Tables";
        }

        private static class Tables
        extends BlockLoot {
            private Tables() {
            }

            protected void addTables() {
                this.m_124288_((Block)ModData.disenchanter_block);
                this.m_124288_((Block)ModData.enchanter_block);
                this.m_124288_((Block)ModData.storage_block);
            }

            @Nonnull
            protected Iterable<Block> getKnownBlocks() {
                return Lists.newArrayList((Object[])new Block[]{ModData.disenchanter_block, ModData.enchanter_block, ModData.storage_block});
            }
        }
    }

    public static class RecipeGenerator
    extends RecipeProvider {
        public RecipeGenerator(DataGenerator generatorIn) {
            super(generatorIn);
        }

        protected void m_176531_(@Nonnull Consumer<FinishedRecipe> consumer) {
            ShapedRecipeBuilder.m_126116_((ItemLike)ModData.storage_block).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50723_).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42415_).m_126130_("BBB").m_126130_("D#D").m_126130_("###").m_142284_("has_obsidian", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Blocks.f_50723_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)ModData.disenchanter_block).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50723_).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42391_).m_126130_(" B ").m_126130_("D#D").m_126130_("###").m_142284_("has_obsidian", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Blocks.f_50723_)).m_176498_(consumer);
            ShapedRecipeBuilder.m_126116_((ItemLike)ModData.enchanter_block).m_126127_(Character.valueOf('B'), (ItemLike)Items.f_42517_).m_126127_(Character.valueOf('#'), (ItemLike)Blocks.f_50723_).m_126127_(Character.valueOf('D'), (ItemLike)Items.f_42415_).m_126130_(" B ").m_126130_("D#D").m_126130_("###").m_142284_("has_obsidian", (CriterionTriggerInstance)RecipeGenerator.m_125977_((ItemLike)Blocks.f_50723_)).m_176498_(consumer);
        }

        @Nonnull
        public String m_6055_() {
            return "EnchantmentMachine Recipes";
        }
    }

    public static class ModBlockTagsProvider
    extends BlockTagsProvider {
        public ModBlockTagsProvider(DataGenerator p_126511_, @Nullable ExistingFileHelper existingFileHelper) {
            super(p_126511_, "enchantmentmachine", existingFileHelper);
        }

        protected void m_6577_() {
            this.m_206424_(BlockTags.f_144282_).m_126584_((Object[])new Block[]{ModData.disenchanter_block, ModData.enchanter_block, ModData.storage_block});
        }

        @Nonnull
        public String m_6055_() {
            return "EnchantmentMachine Block Tags";
        }
    }
}

