/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.network;

import de.cheaterpaul.enchantmentmachine.network.IMessage;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceKey;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.level.Level;
import net.minecraftforge.network.PacketDistributor;
import net.minecraftforge.network.simple.SimpleChannel;

public abstract class AbstractPacketDispatcher {
    protected final SimpleChannel dispatcher;
    private byte packetId = 0;

    protected AbstractPacketDispatcher(SimpleChannel channel) {
        this.dispatcher = channel;
    }

    public abstract void registerPackets();

    public final void sendTo(@Nonnull IMessage message, ServerPlayer player) {
        Objects.requireNonNull(message);
        this.dispatcher.send(PacketDistributor.PLAYER.with(() -> player), (Object)message);
    }

    public final void sendToAll(IMessage message) {
        this.dispatcher.send(PacketDistributor.ALL.noArg(), (Object)message);
    }

    public final void sendToAllAround(IMessage message, ResourceKey<Level> dimension, double x, double y, double z, double range) {
        this.sendToAllAround(message, new PacketDistributor.TargetPoint(x, y, z, range, dimension));
    }

    public final void sendToAllAround(IMessage message, PacketDistributor.TargetPoint point) {
        this.dispatcher.send(PacketDistributor.NEAR.with(() -> point), (Object)message);
    }

    public final void sendToAllTrackingPlayers(IMessage message, Entity target) {
        this.dispatcher.send(PacketDistributor.TRACKING_ENTITY_AND_SELF.with(() -> target), (Object)message);
    }

    public final void sendToServer(IMessage message) {
        this.dispatcher.sendToServer((Object)message);
    }

    protected int nextID() {
        byte by = this.packetId;
        this.packetId = (byte)(by + 1);
        return by;
    }
}

