/*
 * Decompiled with CFR 0.152.
 */
package de.cheaterpaul.enchantmentmachine.util;

import de.cheaterpaul.enchantmentmachine.core.ModConfig;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.enchantment.Enchantment;
import org.apache.commons.lang3.tuple.Pair;

public record EnchantmentInstanceMod(@Nonnull Enchantment enchantment, int level) {
    public int getLevel() {
        return this.level;
    }

    @Nonnull
    public Enchantment getEnchantment() {
        return this.enchantment;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EnchantmentInstanceMod that = (EnchantmentInstanceMod)o;
        return this.level == that.level && this.enchantment.equals(that.enchantment);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.enchantment, this.level);
    }

    @Override
    public String toString() {
        return "EnchantmentInstanceMod{enchantment=" + this.enchantment + ", level=" + this.level + "}";
    }

    public boolean canEnchant() {
        return ((List)ModConfig.SERVER.maxEnchantmentLevels.get()).stream().map(s -> {
            String[] maxLevels = s.split("\\|");
            return Pair.of((Object)new ResourceLocation(maxLevels[0]), (Object)Integer.parseInt(maxLevels[1]));
        }).filter(e -> ((ResourceLocation)e.getKey()).equals((Object)this.enchantment.getRegistryName())).noneMatch(a -> (Integer)a.getValue() < this.level);
    }
}

