/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares;

import java.util.Collection;
import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.block.FlareLightBlock;
import me.lizardofoz.drgflares.client.SettingsScreen;
import me.lizardofoz.drgflares.config.PlayerSettings;
import me.lizardofoz.drgflares.config.ServerSettings;
import me.lizardofoz.drgflares.util.DRGFlareLimiter;
import me.lizardofoz.drgflares.util.DRGFlarePlayerAspect;
import me.lizardofoz.drgflares.util.DRGFlaresUtil;
import me.lizardofoz.drgflares.util.FlareColor;
import me.lizardofoz.drgflares.util.ServerSyncMode;
import net.minecraft.client.Minecraft;
import net.minecraft.client.player.LocalPlayer;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public abstract class CommonEvents {
    protected abstract void sendSettingsSyncS2CPacket(ServerPlayer var1);

    protected void onServerStart(MinecraftServer server) {
        DRGFlareRegistry.getInstance().serverSyncMode = ServerSyncMode.SYNC_WITH_SERVER;
        DRGFlareLimiter.initOrReset();
        DRGFlarePlayerAspect.initOrReset();
        ServerSettings.CURRENT.loadFromJson(ServerSettings.LOCAL.asJson());
        FlareLightBlock.refreshBlockStates();
        if (!((Boolean)ServerSettings.CURRENT.flareRecipesInSurvival.value).booleanValue()) {
            Collection values = server.m_129894_().m_44051_();
            values.removeIf(it -> it.m_6423_().m_135827_().equals("drg_flares"));
            DRGFlaresUtil.setRecipes(server.m_129894_(), values);
        }
    }

    protected void onServerTick() {
        DRGFlareLimiter.tick();
        DRGFlarePlayerAspect.tickAll();
    }

    protected void onPlayerJoinServer(ServerPlayer player) {
        DRGFlareLimiter.onPlayerJoin((Player)player);
        DRGFlarePlayerAspect.onPlayerJoin((Player)player);
        DRGFlaresUtil.unlockFlareRecipes((Player)player);
        this.sendSettingsSyncS2CPacket(player);
    }

    protected void onPlayerLeaveServer(Player player) {
        DRGFlareLimiter.onPlayerLeave(player);
        DRGFlarePlayerAspect.onPlayerLeave(player);
    }

    @OnlyIn(value=Dist.CLIENT)
    protected static abstract class Client {
        protected Client() {
        }

        protected abstract void sendFlareThrowC2SPacket(FlareColor var1);

        protected void onClientTick(Minecraft client) {
            LocalPlayer player = client.f_91074_;
            if (player == null || client.m_91104_()) {
                return;
            }
            DRGFlareLimiter.tick();
            DRGFlarePlayerAspect.clientLocal.tick();
            if (DRGFlareRegistry.getInstance().isClothConfigLoaded() && PlayerSettings.INSTANCE.flareModSettingsKey.m_90859_()) {
                client.m_91152_(SettingsScreen.create(client.f_91080_));
            }
            if (PlayerSettings.INSTANCE.throwFlareKey.m_90859_() && !DRGFlaresUtil.isRegenFlareOnCooldown((Player)player)) {
                if (DRGFlarePlayerAspect.clientLocal.checkFlareToss((Player)player)) {
                    FlareColor flareColor = FlareColor.RandomColorPicker.unwrapRandom((FlareColor)((Object)PlayerSettings.INSTANCE.flareColor.value), true);
                    if (DRGFlareRegistry.getInstance().serverSyncMode != ServerSyncMode.SYNC_WITH_SERVER && ((Boolean)ServerSettings.CURRENT.regeneratingFlaresEnabled.value).booleanValue()) {
                        DRGFlarePlayerAspect.clientLocal.tryThrowRegeneratingFlare((Player)Minecraft.m_91087_().f_91074_, flareColor);
                    } else {
                        this.sendFlareThrowC2SPacket(flareColor);
                    }
                } else if (((Boolean)ServerSettings.CURRENT.regeneratingFlaresEnabled.value).booleanValue()) {
                    player.m_6330_(SoundEvents.f_12490_, SoundSource.MASTER, (float)((Integer)PlayerSettings.INSTANCE.flareSoundVolume.value).intValue() / 1234.0f, 1.7f);
                }
            }
        }

        protected void onClientConnect() {
            if (DRGFlareRegistry.getInstance().serverSyncMode == ServerSyncMode.UNDEFINED) {
                DRGFlareRegistry.getInstance().serverSyncMode = ServerSyncMode.CLIENT_ONLY;
                FlareLightBlock.refreshBlockStates();
                ServerSettings.CURRENT.loadFromJson(ServerSettings.LOCAL.asJson());
            }
        }

        protected void onClientDisconnect() {
            DRGFlareRegistry.getInstance().serverSyncMode = ServerSyncMode.UNDEFINED;
        }
    }
}

