/*
 * Decompiled with CFR 0.152.
 */
package me.lizardofoz.drgflares;

import com.google.common.collect.ImmutableMap;
import io.netty.buffer.PooledByteBufAllocator;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import me.lizardofoz.drgflares.DRGFlareRegistry;
import me.lizardofoz.drgflares.block.FlareLightBlock;
import me.lizardofoz.drgflares.block.FlareLightBlockEntity;
import me.lizardofoz.drgflares.entity.FlareEntity;
import me.lizardofoz.drgflares.item.FlareItem;
import me.lizardofoz.drgflares.packet.PacketStuff;
import me.lizardofoz.drgflares.packet.SpawnFlareEntityS2CPacket;
import me.lizardofoz.drgflares.util.FlareColor;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.protocol.Packet;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.MobCategory;
import net.minecraft.world.item.CreativeModeTab;
import net.minecraft.world.item.Item;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.SoundType;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Material;
import net.minecraft.world.level.material.MaterialColor;
import net.minecraftforge.fml.ModList;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.registries.DeferredRegister;
import net.minecraftforge.registries.ForgeRegistries;
import net.minecraftforge.registries.IForgeRegistry;
import net.minecraftforge.server.ServerLifecycleHooks;

public class DRGFlareRegistryForge
extends DRGFlareRegistry {
    private final DeferredRegister<Block> BLOCKS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCKS, (String)"drg_flares");
    private final DeferredRegister<Item> ITEMS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ITEMS, (String)"drg_flares");
    private final DeferredRegister<SoundEvent> SOUNDS = DeferredRegister.create((IForgeRegistry)ForgeRegistries.SOUND_EVENTS, (String)"drg_flares");
    private final DeferredRegister<EntityType<?>> ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.ENTITIES, (String)"drg_flares");
    private final DeferredRegister<BlockEntityType<?>> TILE_ENTITIES = DeferredRegister.create((IForgeRegistry)ForgeRegistries.BLOCK_ENTITIES, (String)"drg_flares");
    private EntityType<FlareEntity> flareEntityType;
    private Map<FlareColor, Item> flareItemTypes;
    private Block lightSourceBlockType;
    private BlockEntityType<FlareLightBlockEntity> lightSourceBlockEntityType;
    private final AtomicReference<Object> isClothConfigLoaded = new AtomicReference();
    private final AtomicReference<Object> isInventorioLoaded = new AtomicReference();

    public static void initialize() {
        DRGFlareRegistry.instance = new DRGFlareRegistryForge();
    }

    private DRGFlareRegistryForge() {
        this.BLOCKS.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.ITEMS.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.TILE_ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.SOUNDS.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.ENTITIES.register(FMLJavaModLoadingContext.get().getModEventBus());
        this.registerFlareItems();
        this.registerFlareEntity();
        this.registerLightBlock();
        this.registerSounds();
    }

    private void registerFlareItems() {
        HashMap<FlareColor, FlareItem> flares = new HashMap<FlareColor, FlareItem>();
        for (FlareColor color : FlareColor.values()) {
            FlareItem flareItem = new FlareItem(new Item.Properties().m_41491_(color == FlareColor.RANDOM || color == FlareColor.RANDOM_BRIGHT_ONLY ? null : CreativeModeTab.f_40753_));
            this.ITEMS.register("drg_flare_" + color.toString(), () -> flareItem);
            flares.put(color, flareItem);
        }
        this.flareItemTypes = ImmutableMap.copyOf(flares);
    }

    private void registerFlareEntity() {
        this.flareEntityType = EntityType.Builder.m_20704_(FlareEntity::make, (MobCategory)MobCategory.MISC).m_20699_(0.4f, 0.2f).setTrackingRange(64).m_20720_().m_20717_(1).m_20712_("drg_flares:drg_flare");
        this.ENTITIES.register("drg_flare", () -> this.flareEntityType);
    }

    private void registerLightBlock() {
        this.lightSourceBlockType = new FlareLightBlock(BlockBehaviour.Properties.m_60939_((Material)new Material.Builder(MaterialColor.f_76398_).m_76356_().m_76353_().m_76359_()).m_60918_(SoundType.f_56736_).m_60978_(3600000.8f).m_60993_().m_60955_().m_60953_(state -> (Integer)state.m_61143_((Property)FlareLightBlock.LIGHT_LEVEL)));
        this.lightSourceBlockEntityType = BlockEntityType.Builder.m_155273_(FlareLightBlockEntity::new, (Block[])new Block[]{this.lightSourceBlockType}).m_58966_(null);
        this.BLOCKS.register("flare_light_block", () -> this.lightSourceBlockType);
        this.TILE_ENTITIES.register("flare_light_block_entity", () -> this.lightSourceBlockEntityType);
    }

    private void registerSounds() {
        this.SOUNDS.register(this.FLARE_THROW.m_135815_(), () -> this.FLARE_THROW_EVENT);
        this.SOUNDS.register(this.FLARE_BOUNCE.m_135815_(), () -> this.FLARE_BOUNCE_EVENT);
        this.SOUNDS.register(this.FLARE_BOUNCE_FAR.m_135815_(), () -> this.FLARE_BOUNCE_FAR_EVENT);
    }

    @Override
    public Packet<?> createSpawnFlareEntityPacket(FlareEntity flareEntity) {
        SpawnFlareEntityS2CPacket packet = new SpawnFlareEntityS2CPacket(flareEntity);
        FriendlyByteBuf buf = new FriendlyByteBuf(PooledByteBufAllocator.DEFAULT.buffer());
        packet.write(buf);
        return PacketStuff.sendFlareSpawnS2CPacket(packet);
    }

    @Override
    public void broadcastSettingsChange() {
        try {
            for (ServerPlayer serverPlayerEntity : ServerLifecycleHooks.getCurrentServer().m_6846_().m_11314_()) {
                PacketStuff.sendSettingsSyncS2CPacket(serverPlayerEntity);
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    @Override
    public EntityType<FlareEntity> getFlareEntityType() {
        return this.flareEntityType;
    }

    @Override
    public Map<FlareColor, Item> getFlareItemTypes() {
        return this.flareItemTypes;
    }

    @Override
    public Block getLightSourceBlockType() {
        return this.lightSourceBlockType;
    }

    @Override
    public BlockEntityType<FlareLightBlockEntity> getLightSourceBlockEntityType() {
        return this.lightSourceBlockEntityType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isClothConfigLoaded() {
        Object value = this.isClothConfigLoaded.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.isClothConfigLoaded;
            synchronized (atomicReference) {
                value = this.isClothConfigLoaded.get();
                if (value == null) {
                    boolean actualValue = ModList.get().isLoaded("cloth_config");
                    value = actualValue;
                    this.isClothConfigLoaded.set(value);
                }
            }
        }
        return (Boolean)value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean isInventorioLoaded() {
        Object value = this.isInventorioLoaded.get();
        if (value == null) {
            AtomicReference<Object> atomicReference = this.isInventorioLoaded;
            synchronized (atomicReference) {
                value = this.isInventorioLoaded.get();
                if (value == null) {
                    boolean actualValue = ModList.get().isLoaded("inventorio");
                    value = actualValue;
                    this.isInventorioLoaded.set(value);
                }
            }
        }
        return (Boolean)value;
    }
}

